Name:           validns
Version:        0.9.0
Release:        1%{?dist}
Summary:        DNS and DNSSEC zone file validator
Group:          Productivity/Networking/DNS/Utilities

License:        BSD-2-Clause
URL:            https://codeberg.org/DNS-OARC/validns
# Source needs to be generated by dist-tools/create-source-packages, see
# https://github.com/jelu/dist-tools
Source0:        %{name}_%{version}.orig.tar.gz

BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
BuildRequires:  pkgconfig
BuildRequires:  openssl-devel
%if 0%{?suse_version}
BuildRequires:  judy-devel
%else
BuildRequires:  Judy-devel
%endif
BuildRequires:  perl(Test::Command::Simple)
BuildRequires:  perl(Test::Harness)

%description
DNS and DNSSEC zone file validator


%prep
%setup -q -n %{name}_%{version}


%build
sh autogen.sh
%configure
%make_build


%install
%make_install


%check
%make_build test


%files
%{_bindir}/validns
%{_datadir}/doc/*
%{_mandir}/man1/validns.*


%changelog
* Fri Jan 30 2026 Jerry Lundström <lundstrom.jerry@gmail.com> 0.9.0-1
- Release 0.9.0
  * Added:
    - Support for WALLET RR type 262
    - Internal txtlike infrastructure for TXT-like RR types, removing 20-segment limit for SPF
    - Full hex data display in generic record verbose output
    - Support for ZoneMD (RFC 8976)
    - Quiet mode for test programs (-v for verbose output)
    - Changie for changelog management
    - -V option to print version
  * Changed:
    - License updated
    - CI infrastructure updates
    - Migration to Codeberg
    - Build system migrated to autotools
  * Fixed:
    - Root zone membership check now correctly allows TLDs
    - Include txtlike.h in distribution tarball
    - Memory management issues (file_info initialization, generate template cleanup)
    - Coredump in NSEC3 handling when zone apex is NULL
    - Coredump when zone has DNSSEC records but no valid SOA
    - Scan-build warnings
    - Prevent crash in KSK policy check when zone has no DNSKEY records
    - Resolve clang scan-build warnings (dead stores, missing noreturn attributes)
    - Prevent crash in NSEC3PARAM policy check when record storage fails
    - Detect and report when DNSSEC signature algorithms are disabled by system crypto policy (RHEL 9/CentOS 9)
* Tue Feb 11 2014 Anton Berezin <tobez@tobez.org> 0.8.0-1
- Release 0.8.0
  * Added:
    - Support ECDSA and SHA-256 in SSHFP
    - Support for SHA-384 digests in DS (RFC 6605)
    - Support multiple -t options
  * Fixed:
    - Miscellaneous bug fixes
    - Miscellaneous portability fixes
