## TFSA-2021-165: Segfault on strings tensors with mismatched dimensions, due to Go code

### CVE Number
CVE-2021-37692

### Impact
Under certain conditions, Go code can trigger a segfault in string deallocation.

For string tensors, `C.TF_TString_Dealloc` is called during garbage collection within a finalizer function.  However, tensor structure isn't checked until encoding to avoid a performance penalty.  The current method for dealloc assumes that encoding succeeded, but segfaults when a string tensor is garbage collected whose encoding failed (e.g., due to mismatched dimensions).

To fix this, the call to set the finalizer function is deferred until `NewTensor` returns and, if encoding failed for a string tensor, deallocs are determined based on bytes written.

### Patches
We have patched the issue in GitHub commit [8721ba96e5760c229217b594f6d2ba332beedf22](https://github.com/tensorflow/tensorflow/commit/8721ba96e5760c229217b594f6d2ba332beedf22) (merging [#50508](https://github.com/tensorflow/tensorflow/pull/50508)).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this commit on TensorFlow 2.5.1, which is the other affected version.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported externally via a [fixing PR](https://github.com/tensorflow/tensorflow/pull/50508).
