% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_base_means.R
\name{getSimulationMeans}
\alias{getSimulationMeans}
\title{Get Simulation Means}
\usage{
getSimulationMeans(
  design = NULL,
  ...,
  groups = 2L,
  normalApproximation = TRUE,
  meanRatio = FALSE,
  thetaH0 = ifelse(meanRatio, 1, 0),
  alternative = seq(0, 1, 0.2),
  stDev = 1,
  plannedSubjects = NA_real_,
  directionUpper = NA,
  allocationRatioPlanned = NA_real_,
  minNumberOfSubjectsPerStage = NA_real_,
  maxNumberOfSubjectsPerStage = NA_real_,
  conditionalPower = NA_real_,
  thetaH1 = NA_real_,
  stDevH1 = NA_real_,
  maxNumberOfIterations = 1000L,
  seed = NA_real_,
  calcSubjectsFunction = NULL,
  showStatistics = FALSE
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{normalApproximation}{The type of computation of the p-values. Default is \code{TRUE},
i.e., normally distributed test statistics are generated.
If \code{FALSE}, the t test is used for calculating the p-values,
i.e., t distributed test statistics are generated.}

\item{meanRatio}{If \code{TRUE}, the design characteristics for
one-sided testing of H0: \code{mu1 / mu2 = thetaH0} are simulated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
\item \emph{count data}: a bound for testing H0: \code{lambda1 / lambda2 = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{alternative}{The alternative hypothesis value for testing means under which the data is simulated.
This can be a vector of assumed alternatives, default is \code{seq(0, 1, 0.2)}.}

\item{stDev}{The standard deviation under which the data is simulated,
default is \code{1}.
For two-armed trials, it is allowed to specify the standard deviations separately,
i.e., as vector with two elements.
If \code{meanRatio = TRUE} is specified, \code{stDev} defines
the coefficient of variation \code{sigma / mu2}.}

\item{plannedSubjects}{\code{plannedSubjects} is a numeric vector of length \code{kMax} (the number of stages of the design)
that determines the number of cumulated (overall) subjects when the interim stages are planned.
For two treatment arms, it is the number of subjects for both treatment arms.
For multi-arm designs, \code{plannedSubjects} refers to the number of subjects per selected active arm.}

\item{directionUpper}{Logical. Specifies the direction of the alternative,
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.
For simulating means and rates for a two treatment groups design, it can be a vector of length \code{kMax}, the number of stages.
It can be a vector of length \code{kMax}, too, for multi-arm and enrichment designs.
In these cases, a change of allocating subjects to treatment groups over the stages can be assessed.
Note that internally \code{allocationRatioPlanned} is treated as a vector of length \code{kMax}, not a scalar.}

\item{minNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation,
the numeric vector \code{minNumberOfSubjectsPerStage} with length \code{kMax} determines the
minimum number of subjects per stage (i.e., not cumulated), the first element
is not taken into account. For two treatment arms, it is the number of subjects for both treatment arms.
For multi-arm designs \code{minNumberOfSubjectsPerStage} refers
to the minimum number of subjects per selected active arm.}

\item{maxNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation,
the numeric vector \code{maxNumberOfSubjectsPerStage} with length \code{kMax} determines the maximum number
of subjects per stage (i.e., not cumulated), the first element is not taken into account.
For two treatment arms, it is the number of subjects for both treatment arms.
For multi-arm designs \code{maxNumberOfSubjectsPerStage} refers
to the maximum number of subjects per selected active arm.}

\item{conditionalPower}{If \code{conditionalPower} together with \code{minNumberOfSubjectsPerStage} and
\code{maxNumberOfSubjectsPerStage} (or \code{minNumberOfEventsPerStage} and \code{maxNumberOfEventsPerStage}
for survival designs) is specified, a sample size recalculation based on the specified conditional power is performed.
It is defined as the power for the subsequent stage given the current data. By default,
the conditional power will be calculated under the observed effect size. Optionally, you can also specify \code{thetaH1} and
\code{stDevH1} (for simulating means), \code{pi1H1} and \code{pi2H1} (for simulating rates), or \code{thetaH1} (for simulating
hazard ratios) as parameters under which it is calculated and the sample size recalculation is performed.}

\item{thetaH1}{If specified, the value of the alternative under which
the conditional power or sample size recalculation calculation is performed. Must be a numeric of length 1.}

\item{stDevH1}{If specified, the value of the standard deviation under which
the conditional power or sample size recalculation calculation is performed,
default is the value of \code{stDev}.}

\item{maxNumberOfIterations}{The number of simulation iterations, default is \code{1000}. Must be a positive integer of length 1.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{calcSubjectsFunction}{Optionally, a function can be entered that defines the way of performing the sample size
recalculation. By default, sample size recalculation is performed with conditional power and specified
\code{minNumberOfSubjectsPerStage} and \code{maxNumberOfSubjectsPerStage} (see details and examples).}

\item{showStatistics}{Logical. If \code{TRUE}, summary statistics of the simulated data
are displayed for the \code{print} command, otherwise the output is suppressed, default
is \code{FALSE}.}
}
\value{
Returns a \code{\link{SimulationResults}} object.
The following generics (R generic functions) are available for this object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.SimulationResults]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.ParameterSet]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the simulated power, stopping probabilities, conditional power, and expected sample size
for testing means in a one or two treatment groups testing situation.
}
\details{
At given design the function simulates the power, stopping probabilities, conditional power, and expected
sample size at given number of subjects and parameter configuration.
Additionally, an allocation ratio = n1/n2 can be specified where n1 and n2 are the number
of subjects in the two treatment groups.

The definition of \code{thetaH1} makes only sense if \code{kMax} > 1
and if \code{conditionalPower}, \code{minNumberOfSubjectsPerStage}, and
\code{maxNumberOfSubjectsPerStage} (or \code{calcSubjectsFunction}) are defined.

\code{calcSubjectsFunction}\cr
This function returns the number of subjects at given conditional power and conditional critical value for specified
testing situation. The function might depend on variables
\code{stage},
\code{meanRatio},
\code{thetaH0},
\code{groups},
\code{plannedSubjects},
\code{sampleSizesPerStage},
\code{directionUpper},
\code{allocationRatioPlanned},
\code{minNumberOfSubjectsPerStage},
\code{maxNumberOfSubjectsPerStage},
\code{conditionalPower},
\code{conditionalCriticalValue},
\code{thetaH1}, and
\code{stDevH1}.
The function has to contain the three-dots argument '...' (see examples).
}
\section{Simulation Data}{

The summary statistics "Simulated data" contains the following parameters: median \link{range}; mean +/-sd\cr

\code{$show(showStatistics = FALSE)} or \code{$setShowStatistics(FALSE)} can be used to disable
the output of the aggregated simulated data.\cr

Example 1: \cr
\code{simulationResults <- getSimulationMeans(plannedSubjects = 40)} \cr
\code{simulationResults$show(showStatistics = FALSE)}\cr

Example 2: \cr
\code{simulationResults <- getSimulationMeans(plannedSubjects = 40)} \cr
\code{simulationResults$setShowStatistics(FALSE)}\cr
\code{simulationResults}\cr

\code{\link[=getData]{getData()}} can be used to get the aggregated simulated data from the
object as \code{\link[base]{data.frame}}. The data frame contains the following columns:
\enumerate{
\item \code{iterationNumber}: The number of the simulation iteration.
\item \code{stageNumber}: The stage.
\item \code{alternative}: The alternative hypothesis value.
\item \code{numberOfSubjects}: The number of subjects under consideration when the
(interim) analysis takes place.
\item \code{rejectPerStage}: 1 if null hypothesis can be rejected, 0 otherwise.
\item \code{futilityPerStage}: 1 if study should be stopped for futility, 0 otherwise.
\item \code{testStatistic}: The test statistic that is used for the test decision,
depends on which design was chosen (group sequential, inverse normal, or Fisher's combination test).
\item \code{testStatisticsPerStage}: The test statistic for each stage if only data from
the considered stage is taken into account.
\item \code{effectEstimate}: Overall simulated standardized effect estimate.
\item \code{trialStop}: \code{TRUE} if study should be stopped for efficacy or futility or final stage, \code{FALSE} otherwise.
\item \code{conditionalPowerAchieved}: The conditional power for the subsequent stage of the trial for
selected sample size and effect. The effect is either estimated from the data or can be
user defined with \code{thetaH1}.
}
}

\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\dontrun{
# Fixed sample size design with two groups, total sample size 40,
# alternative = c(0, 0.2, 0.4, 0.8, 1), and standard deviation = 1 (the default)
getSimulationMeans(plannedSubjects = 40, maxNumberOfIterations = 10)

# Increase number of simulation iterations and compare results
# with power calculator using normal approximation
getSimulationMeans(
    alternative = 0:4, stDev = 5,
    plannedSubjects = 40, maxNumberOfIterations = 1000
)
getPowerMeans(
    alternative = 0:4, stDev = 5,
    maxNumberOfSubjects = 40, normalApproximation = TRUE
)

# Do the same for a three-stage O'Brien&Fleming inverse
# normal group sequential design with non-binding futility stops
designIN <- getDesignInverseNormal(typeOfDesign = "OF", futilityBounds = c(0, 0))
x <- getSimulationMeans(designIN,
    alternative = c(0:4), stDev = 5,
    plannedSubjects = c(20, 40, 60), maxNumberOfIterations = 1000
)
getPowerMeans(designIN,
    alternative = 0:4, stDev = 5,
    maxNumberOfSubjects = 60, normalApproximation = TRUE
)

# Assess power and average sample size if a sample size increase is foreseen
# at conditional power 80\% for each subsequent stage based on observed overall
# effect and specified minNumberOfSubjectsPerStage and
# maxNumberOfSubjectsPerStage
getSimulationMeans(designIN,
    alternative = 0:4, stDev = 5,
    plannedSubjects = c(20, 40, 60),
    minNumberOfSubjectsPerStage = c(NA, 20, 20),
    maxNumberOfSubjectsPerStage = c(NA, 80, 80),
    conditionalPower = 0.8,
    maxNumberOfIterations = 50
)

# Do the same under the assumption that a sample size increase only takes
# place at the first interim. The sample size for the third stage is set equal
# to the second stage sample size.
mySampleSizeCalculationFunction <- function(..., stage,
        minNumberOfSubjectsPerStage,
        maxNumberOfSubjectsPerStage,
        sampleSizesPerStage,
        conditionalPower,
        conditionalCriticalValue,
        allocationRatioPlanned,
        thetaH1,
        stDevH1) {
    if (stage <= 2) {
        # Note that allocationRatioPlanned is as a vector of length kMax
        stageSubjects <- (1 + allocationRatioPlanned[stage])^2 / 
            allocationRatioPlanned[stage] *
            (max(0, conditionalCriticalValue + stats::qnorm(conditionalPower)))^2 /
            (max(1e-12, thetaH1 / stDevH1))^2
        stageSubjects <- min(max(
            minNumberOfSubjectsPerStage[stage],
            stageSubjects
        ), maxNumberOfSubjectsPerStage[stage])
    } else {
        stageSubjects <- sampleSizesPerStage[stage - 1]
    }
    return(stageSubjects)
}
getSimulationMeans(designIN,
    alternative = 0:4, stDev = 5,
    plannedSubjects = c(20, 40, 60),
    minNumberOfSubjectsPerStage = c(NA, 20, 20),
    maxNumberOfSubjectsPerStage = c(NA, 80, 80),
    conditionalPower = 0.8,
    calcSubjectsFunction = mySampleSizeCalculationFunction,
    maxNumberOfIterations = 50
)
}

}
