% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis_base.R
\name{getStageResults}
\alias{getStageResults}
\title{Get Stage Results}
\usage{
getStageResults(design, dataInput, ..., stage = NA_integer_)
}
\arguments{
\item{design}{The trial design.}

\item{dataInput}{The summary data used for calculating the test results.
This is either an element of \code{DatasetMeans}, of \code{DatasetRates}, or of \code{DatasetSurvival}
and should be created with the function \code{\link[=getDataset]{getDataset()}}.
For more information see \code{\link[=getDataset]{getDataset()}}.}

\item{...}{Further (optional) arguments to be passed:
\describe{
\item{\code{thetaH0}}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0:
\code{hazard ratio = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}
\item{\code{normalApproximation}}{The
type of computation of the p-values. Default is \code{FALSE} for
testing means (i.e., the t test is used) and \code{TRUE} for testing rates and the hazard ratio.
For testing rates, if \code{normalApproximation = FALSE} is specified, the binomial test
(one sample) or the exact test of Fisher (two samples) is used for calculating the p-values.
In the survival setting, \code{normalApproximation = FALSE} has no effect.}
\item{\code{equalVariances}}{The type of t test. For testing means in two treatment groups, either
the t test assuming that the variances are equal or the t test without assuming this,
i.e., the test of Welch-Satterthwaite is calculated, default is \code{TRUE}.}
\item{\code{directionUpper}}{The direction of one-sided testing.
Default is \code{TRUE} which means that larger values of the
test statistics yield smaller p-values.}
\item{\code{intersectionTest}}{Defines the multiple test for the intersection
hypotheses in the closed system of hypotheses when testing multiple hypotheses.
Five options are available in multi-arm designs: \code{"Dunnett"}, \code{"Bonferroni"}, \code{"Simes"},
\code{"Sidak"}, and \code{"Hierarchical"}, default is \code{"Dunnett"}.
Four options are available in population enrichment designs: \code{"SpiessensDebois"} (one subset only),
\code{"Bonferroni"}, \code{"Simes"}, and \code{"Sidak"}, default is \code{"Simes"}.}
\item{\code{varianceOption}}{Defines the way to calculate the variance in multiple treatment arms (> 2)
or population enrichment designs for testing means. For multiple arms, three options are available:
\code{"overallPooled"}, \code{"pairwisePooled"}, and \code{"notPooled"}, default is \code{"overallPooled"}.
For enrichment designs, the options are: \code{"pooled"}, \code{"pooledFromFull"} (one subset only),
and \code{"notPooled"}, default is \code{"pooled"}.}
\item{\code{stratifiedAnalysis}}{For enrichment designs, typically a stratified analysis should be chosen.
For testing means and rates, also a non-stratified analysis based on overall data can be performed.
For survival data, only a stratified analysis is possible (see Brannath et al., 2009), default is \code{TRUE}.}
}}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input.}
}
\value{
Returns a \code{\link{StageResults}} object.
\itemize{
\item \code{\link[=names.StageResults]{names}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.StageResults]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.StageResults]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns summary statistics and p-values for a given data set and a given design.
}
\details{
Calculates and returns the stage results of the specified design and data input at the specified stage.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
design <- getDesignInverseNormal()
dataRates <- getDataset(
    n1      = c(10, 10),
    n2      = c(20, 20),
    events1 = c( 8, 10),
    events2 = c(10, 16))
getStageResults(design, dataRates)

}
\seealso{
Other analysis functions: 
\code{\link{getAnalysisResults}()},
\code{\link{getClosedCombinationTestResults}()},
\code{\link{getClosedConditionalDunnettTestResults}()},
\code{\link{getConditionalPower}()},
\code{\link{getConditionalRejectionProbabilities}()},
\code{\link{getFinalConfidenceInterval}()},
\code{\link{getFinalPValue}()},
\code{\link{getRepeatedConfidenceIntervals}()},
\code{\link{getRepeatedPValues}()},
\code{\link{getTestActions}()}
}
\concept{analysis functions}
