% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.aalen.model.R
\name{predict.aalen.model}
\alias{predict.aalen.model}
\title{Subject-specific prediction for an Aalen model}
\usage{
\method{predict}{aalen.model}(object, newdata, type = "Haz", ...)
}
\arguments{
\item{object}{A survaalen or rsaalen object}

\item{newdata}{A data.frame with one row (add covariate values in columns)}

\item{type}{By default ('Haz') returns cumulative hazards. If 'prob' it calculates CDF/CIFs. If 'both' a list is returned with Haz and prob.}

\item{...}{Not used for now}
}
\value{
A data.frame containing the times and survival (or excess/population) estimates.
}
\description{
A function that returns subject-specific predictions from a survaalen or rsaalen object.
}
\examples{
data(rdata)
mod <- survaalen(Surv(time, cens)~sex+age, data=rdata)
predict(mod, data.frame(age=68, sex=2))

mod <- rsaalen(Surv(time, cens)~sex+age, data=rdata, ratetable=slopop,
                rmap=list(age=age*365.241))
predict(mod, data.frame(age=68, sex=2, year=as.Date('1982-06-24')))
}
\author{
Damjan Manevski \email{damjan.manevski@mf.uni-lj.si}
}
