% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_write.R
\name{print.rdocx}
\alias{print.rdocx}
\title{Write a 'Word' File}
\usage{
\method{print}{rdocx}(
  x,
  target = NULL,
  copy_header_refs = FALSE,
  copy_footer_refs = FALSE,
  preview = FALSE,
  ...
)
}
\arguments{
\item{x}{an \code{rdocx} object created with \code{\link[=read_docx]{read_docx()}}}

\item{target}{path to the \code{.docx} file to write. The file will be created
or overwritten if it already exists. If \code{NULL} and \code{preview = FALSE}, the
function returns \code{NULL} without writing a file.}

\item{copy_header_refs, copy_footer_refs}{logical, default is FALSE.
If TRUE, copy the references to the header and footer in each section
of the body of the document. This parameter is experimental and may change
in a future version.}

\item{preview}{Save \code{x} to a temporary file and open it (default \code{FALSE}).
When \code{TRUE}, the document is saved to a temporary location and opened with
the system's default application for \code{.docx} files, useful for quick previewing
during development.}

\item{...}{unused}
}
\value{
The full path to the created \code{.docx} file (invisibly). This allows
chaining operations or capturing the output path for further use.
}
\description{
\code{print.rdocx()} is the essential output function for creating Word files
with officer. It takes an \code{rdocx} object (created with \code{\link[=read_docx]{read_docx()}} and
populated with content) and writes it to disk as a \code{.docx} file.

This function performs all necessary post-processing operations before
writing the file.

The function is typically called at the end of your document creation
workflow, after all content has been added with \verb{body_add_*()} functions.
}
\examples{
library(officer)

# This example demonstrates how to create
# an small document -----

## Create a new Word document
doc <- read_docx()
doc <- body_add_par(doc, "hello world")
## Save the document
output_file <- print(doc, target = tempfile(fileext = ".docx"))

# preview mode: save to temp file and open locally ----
## Not run:
# print(doc, preview = TRUE)
}
\seealso{
Create a 'Word' document object with \code{\link[=read_docx]{read_docx()}}, add content with
functions \code{\link[=body_add_par]{body_add_par()}}, \code{\link[=body_add_plot]{body_add_plot()}},
\code{\link[=body_add_table]{body_add_table()}}, change settings with \code{\link[=docx_set_settings]{docx_set_settings()}}, set
properties with \code{\link[=set_doc_properties]{set_doc_properties()}},  read 'Word' styles with
\code{\link[=styles_info]{styles_info()}}.
}
