% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empty_assignment_linter.R
\name{empty_assignment_linter}
\alias{empty_assignment_linter}
\title{Block assignment of \code{{}}}
\usage{
empty_assignment_linter()
}
\description{
Assignment of \code{{}} is the same as assignment of \code{NULL}; use the latter
for clarity. Closely related: \code{\link[=unnecessary_concatenation_linter]{unnecessary_concatenation_linter()}}.
}
\examples{
# will produce lints
lint(
  text = "x <- {}",
  linters = empty_assignment_linter()
)

writeLines("x = {\n}")
lint(
  text = "x = {\n}",
  linters = empty_assignment_linter()
)

# okay
lint(
  text = "x <- { 3 + 4 }",
  linters = empty_assignment_linter()
)

lint(
  text = "x <- NULL",
  linters = empty_assignment_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=readability_linters]{readability}
}
