% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{data}
\name{class_definitions}
\alias{class_definitions}
\alias{class_gg}
\alias{class_ggproto}
\alias{class_scale}
\alias{class_guides}
\alias{class_guide}
\alias{class_coord}
\alias{class_facet}
\alias{class_layer}
\alias{class_layout}
\alias{class_scales_list}
\alias{class_S3_gg}
\alias{class_rel}
\alias{class_zero_grob}
\alias{class_waiver}
\alias{class_derive}
\title{Class definitions}
\description{
The S7 object oriented programming system requires class definitions.
Here, we provide definitions of classes that are home to ggplot2.
}
\section{S7 classes}{


A general advice the S7 package gives is to name class definition objects
the same as the class name, which then becomes the constructor for the class.
The classes listed below deviate from that advice for historical reasons,
because some constructors like \code{ggplot()} are also S3 generics with methods.
The have the \code{class_}-prefix to indicate their role.
\itemize{
\item \code{\link{class_ggplot}} is an S7 class used for objects generated by \code{\link[=ggplot]{ggplot()}}.
\item \code{\link{class_ggplot_built}} is an S7 class used for objects generated by
\code{\link[=ggplot_build]{ggplot_build()}}.
\item \code{\link{class_mapping}} is an S7 class used for objects generated by \code{\link[=aes]{aes()}}.
\item \code{\link{class_theme}} is an S7 class used for objects generated by \code{\link[=theme]{theme()}}.
\item \code{\link{class_labels}} is an S7 class used for objects generated by \code{\link[=labs]{labs()}}.
}


\itemize{
\item \code{class_gg} is an abstract S7 class to used invoke similar behaviour among
ggplot objects.
}
}

\section{Theme elements}{


The theme elements follow the advice of the S7 package that the class names
are also the class definitions and constructors.
\itemize{
\item \code{\link{element}} is an abstract S7 class used to invoke similar behaviour among
theme element objects.
\item \code{\link{element_blank}} is an S7 class for not drawing theme elements.
\item \code{\link{element_rect}} is an S7 class for drawing rectangles.
\item \code{\link{element_line}} is an S7 class for drawing lines.
\item \code{\link{element_text}} is an S7 class for rendering text.
\item \code{\link{element_polygon}} is an S7 class for drawing polygons.
\item \code{\link{element_point}} is an S7 class for drawing points.
\item \code{\link{element_geom}} is an S7 class holding geom defaults.
\item \code{\link{margin}} is an S7 class for declaring margins.
}
}

\section{ggproto classes}{


The ggproto classes are S3 classes of the type environment that form the
backbone of most systems in ggplot2 and are in particular crucial to the
extension system.


\itemize{
\item \code{class_ggproto} is an S3 class used for the objects generated by
\code{\link[=ggproto]{ggproto()}} which are of the type environment.
}


\itemize{
\item \code{class_scale} is a subclass of \code{class_ggproto} and is more described in
the \link{Scale} documentation.
}


\itemize{
\item \code{class_guides} is a subclass of \code{class_ggproto} and is considered an
internal class.
}


\itemize{
\item \code{class_guide} is a subclass of \code{class_ggproto} and is more described in the
\link{Guide} documentation.
}


\itemize{
\item \code{class_coord} is a subclass of \code{class_ggproto} and is more described in the
\link{Coord} documentation.
}


\itemize{
\item \code{class_facet} is a subclass of \code{class_ggproto} and is more described in the
\link{Facet} documentation.
}


\itemize{
\item \code{class_layer} is a subclass of \code{class_ggproto} and is used for the objects
generated by \code{\link[=layer]{layer()}}. The class itself is considered internal and is
described in more detail in the \link{Layer} documentation.
}


\itemize{
\item \code{class_layout} is a subclass of \code{class_ggproto} and is considered an
internal class. It is described in more detail in the \link{Layout}
documentation.
}


\itemize{
\item \code{class_scales_list} is a subclass of \code{class_ggproto} and is considered an
internal class.
}
}

\section{S3 classes}{


Some simple classes remain S3, primarily because they aren't meant to be
recycled into new classes.


\itemize{
\item \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} \code{class_S3_gg} is a temporary S3 class
until R 4.3.0 is the minimum  supported version. It is exported and
listed here for completeness, but its use is heavily discouraged. It
is superseded by \code{class_gg}.
}


\itemize{
\item \code{class_rel} is an S3 class used in \link{element} properties.
}


\itemize{
\item \code{class_zero_grob} is an S3 class used to indicate empty drawings.
}


\itemize{
\item \code{class_waiver} is an S3 sentinel value class used in various places.
}


\itemize{
\item \code{class_derive} is an S3 sentinel value class used primarily in \code{\link[=sec_axis]{sec_axis()}}.
}
}

\keyword{datasets}
\keyword{internal}
