# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagement(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_put_bastion_shareable_link(self, resource_group):
        response = self.client.begin_put_bastion_shareable_link(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            bsl_request={
                "vms": [
                    {
                        "vm": {"id": "str", "location": "str", "name": "str", "tags": {"str": "str"}, "type": "str"},
                        "bsl": "str",
                        "createdAt": "str",
                        "message": "str",
                    }
                ]
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete_bastion_shareable_link(self, resource_group):
        response = self.client.begin_delete_bastion_shareable_link(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            bsl_request={
                "vms": [
                    {
                        "vm": {"id": "str", "location": "str", "name": "str", "tags": {"str": "str"}, "type": "str"},
                        "bsl": "str",
                        "createdAt": "str",
                        "message": "str",
                    }
                ]
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete_bastion_shareable_link_by_token(self, resource_group):
        response = self.client.begin_delete_bastion_shareable_link_by_token(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            bsl_token_request={"tokens": ["str"]},
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_bastion_shareable_link(self, resource_group):
        response = self.client.get_bastion_shareable_link(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            bsl_request={
                "vms": [
                    {
                        "vm": {"id": "str", "location": "str", "name": "str", "tags": {"str": "str"}, "type": "str"},
                        "bsl": "str",
                        "createdAt": "str",
                        "message": "str",
                    }
                ]
            },
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_get_active_sessions(self, resource_group):
        response = self.client.begin_get_active_sessions(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disconnect_active_sessions(self, resource_group):
        response = self.client.disconnect_active_sessions(
            resource_group_name=resource_group.name,
            bastion_host_name="str",
            session_ids={"sessionIds": ["str"]},
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_check_dns_name_availability(self, resource_group):
        response = self.client.check_dns_name_availability(
            location="str",
            domain_name_label="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_express_route_provider_port(self, resource_group):
        response = self.client.express_route_provider_port(
            providerport="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_active_connectivity_configurations(self, resource_group):
        response = self.client.list_active_connectivity_configurations(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            parameters={"regions": ["str"], "skipToken": "str"},
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_active_security_admin_rules(self, resource_group):
        response = self.client.list_active_security_admin_rules(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            parameters={"regions": ["str"], "skipToken": "str"},
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_network_manager_effective_connectivity_configurations(self, resource_group):
        response = self.client.list_network_manager_effective_connectivity_configurations(
            resource_group_name=resource_group.name,
            virtual_network_name="str",
            parameters={"skipToken": "str"},
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_network_manager_effective_security_admin_rules(self, resource_group):
        response = self.client.list_network_manager_effective_security_admin_rules(
            resource_group_name=resource_group.name,
            virtual_network_name="str",
            parameters={"skipToken": "str"},
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_supported_security_providers(self, resource_group):
        response = self.client.supported_security_providers(
            resource_group_name=resource_group.name,
            virtual_wan_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_generatevirtualwanvpnserverconfigurationvpnprofile(self, resource_group):
        response = self.client.begin_generatevirtualwanvpnserverconfigurationvpnprofile(
            resource_group_name=resource_group.name,
            virtual_wan_name="str",
            vpn_client_params={"authenticationMethod": "str", "vpnServerConfigurationResourceId": "str"},
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
