# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.hdinsight import HDInsightManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hdinsight
# USAGE
    python hdi_locations_validate_cluster_create_request.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HDInsightManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.locations.validate_cluster_create_request(
        location="southcentralus",
        parameters={
            "fetchAaddsResource": False,
            "location": "southcentralus",
            "name": "testclustername",
            "properties": {
                "clusterDefinition": {
                    "componentVersion": {"Spark": "2.4"},
                    "configurations": {
                        "gateway": {
                            "restAuthCredential.isEnabled": True,
                            "restAuthCredential.password": "**********",
                            "restAuthCredential.username": "admin",
                        }
                    },
                    "kind": "spark",
                },
                "clusterVersion": "4.0",
                "computeProfile": {
                    "roles": [
                        {
                            "autoscale": None,
                            "dataDisksGroups": None,
                            "hardwareProfile": {"vmSize": "Standard_E8_V3"},
                            "minInstanceCount": 1,
                            "name": "headnode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "********", "username": "sshuser"}
                            },
                            "scriptActions": [],
                            "targetInstanceCount": 2,
                            "virtualNetworkProfile": None,
                        },
                        {
                            "autoscale": None,
                            "dataDisksGroups": None,
                            "hardwareProfile": {"vmSize": "Standard_E8_V3"},
                            "name": "workernode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "********", "username": "sshuser"}
                            },
                            "scriptActions": [],
                            "targetInstanceCount": 4,
                            "virtualNetworkProfile": None,
                        },
                        {
                            "autoscale": None,
                            "dataDisksGroups": None,
                            "hardwareProfile": {"vmSize": "Standard_D13_V2"},
                            "minInstanceCount": 1,
                            "name": "zookeepernode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "**********", "username": "sshuser"}
                            },
                            "scriptActions": [],
                            "targetInstanceCount": 3,
                            "virtualNetworkProfile": None,
                        },
                    ]
                },
                "minSupportedTlsVersion": "1.2",
                "osType": "Linux",
                "storageProfile": {
                    "storageaccounts": [
                        {
                            "container": "contianername",
                            "enableSecureChannel": True,
                            "isDefault": True,
                            "key": "*******",
                            "name": "storagename.blob.core.windows.net",
                            "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storagename",
                        }
                    ]
                },
                "tier": "Standard",
            },
            "tags": {},
            "tenantId": "00000000-0000-0000-0000-000000000000",
            "type": "Microsoft.HDInsight/clusters",
        },
    )
    print(response)


# x-ms-original-file: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2025-01-15-preview/examples/HDI_Locations_ValidateClusterCreateRequest.json
if __name__ == "__main__":
    main()
