# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Association(TrackedResource):
    """Association Subresource of Traffic Controller.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.AssociationProperties
    """

    properties: Optional["_models.AssociationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssociationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssociationProperties(_model_base.Model):
    """Association Properties.

    :ivar association_type: Association Type. Required. "subnets"
    :vartype association_type: str or ~azure.mgmt.servicenetworking.models.AssociationType
    :ivar subnet: Association Subnet.
    :vartype subnet: ~azure.mgmt.servicenetworking.models.AssociationSubnet
    :ivar provisioning_state: Provisioning State of Traffic Controller Association Resource. Known
     values are: "Provisioning", "Updating", "Deleting", "Accepted", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    association_type: Union[str, "_models.AssociationType"] = rest_field(
        name="associationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Association Type. Required. \"subnets\""""
    subnet: Optional["_models.AssociationSubnet"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Association Subnet."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of Traffic Controller Association Resource. Known values are:
     \"Provisioning\", \"Updating\", \"Deleting\", \"Accepted\", \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        association_type: Union[str, "_models.AssociationType"],
        subnet: Optional["_models.AssociationSubnet"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssociationSubnet(_model_base.Model):
    """Association Subnet.

    :ivar id: Association ID. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Association ID. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssociationSubnetUpdate(_model_base.Model):
    """Association Subnet.

    :ivar id: Association ID.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Association ID."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssociationUpdate(_model_base.Model):
    """The type used for update operations of the Association.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.AssociationUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.AssociationUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssociationUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssociationUpdateProperties(_model_base.Model):
    """The updatable properties of the Association.

    :ivar association_type: Association Type. "subnets"
    :vartype association_type: str or ~azure.mgmt.servicenetworking.models.AssociationType
    :ivar subnet: Association Subnet.
    :vartype subnet: ~azure.mgmt.servicenetworking.models.AssociationSubnetUpdate
    """

    association_type: Optional[Union[str, "_models.AssociationType"]] = rest_field(
        name="associationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Association Type. \"subnets\""""
    subnet: Optional["_models.AssociationSubnetUpdate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Association Subnet."""

    @overload
    def __init__(
        self,
        *,
        association_type: Optional[Union[str, "_models.AssociationType"]] = None,
        subnet: Optional["_models.AssociationSubnetUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.servicenetworking.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.servicenetworking.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.servicenetworking.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Frontend(TrackedResource):
    """Frontend Sub Resource of Traffic Controller.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.FrontendProperties
    """

    properties: Optional["_models.FrontendProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FrontendProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FrontendProperties(_model_base.Model):
    """Frontend Properties.

    :ivar fqdn: The Fully Qualified Domain Name of the DNS record associated to a Traffic
     Controller frontend.
    :vartype fqdn: str
    :ivar security_policy_configurations: Frontend Security Policy Configuration.
    :vartype security_policy_configurations:
     ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurations
    :ivar provisioning_state: Provisioning State of Traffic Controller Frontend Resource. Known
     values are: "Provisioning", "Updating", "Deleting", "Accepted", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    fqdn: Optional[str] = rest_field(visibility=["read"])
    """The Fully Qualified Domain Name of the DNS record associated to a Traffic Controller frontend."""
    security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = rest_field(
        name="securityPolicyConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Frontend Security Policy Configuration."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of Traffic Controller Frontend Resource. Known values are: \"Provisioning\",
     \"Updating\", \"Deleting\", \"Accepted\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FrontendUpdate(_model_base.Model):
    """The type used for update operations of the Frontend.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.FrontendUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.FrontendUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FrontendUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FrontendUpdateProperties(_model_base.Model):
    """The updatable properties of the Frontend.

    :ivar security_policy_configurations: Frontend Security Policy Configuration.
    :vartype security_policy_configurations:
     ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurations
    """

    security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = rest_field(
        name="securityPolicyConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Frontend Security Policy Configuration."""

    @overload
    def __init__(
        self,
        *,
        security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpAccessRule(_model_base.Model):
    """Ip Access Policy Rules.

    :ivar name: Name of the Ip Access Rule. Required.
    :vartype name: str
    :ivar priority: The priority of the rule. The value can be between 1 and 500. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule. Required.
    :vartype priority: int
    :ivar source_address_prefixes: Source Address Prefixed Applied by the Rule. Asterisk '*' can
     also be used to match all source IPs. Required.
    :vartype source_address_prefixes: list[str]
    :ivar action: Action of the Rule. Required. Known values are: "allow" and "deny".
    :vartype action: str or ~azure.mgmt.servicenetworking.models.IpAccessRuleAction
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the Ip Access Rule. Required."""
    priority: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of the rule. The value can be between 1 and 500. The priority number must be
     unique for each rule in the collection. The lower the priority number, the higher the priority
     of the rule. Required."""
    source_address_prefixes: List[str] = rest_field(
        name="sourceAddressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source Address Prefixed Applied by the Rule. Asterisk '*' can also be used to match all source
     IPs. Required."""
    action: Union[str, "_models.IpAccessRuleAction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Action of the Rule. Required. Known values are: \"allow\" and \"deny\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        priority: int,
        source_address_prefixes: List[str],
        action: Union[str, "_models.IpAccessRuleAction"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpAccessRulesPolicy(_model_base.Model):
    """Ip Access Policy.

    :ivar rules: Ip Access Policy Rules List.
    :vartype rules: list[~azure.mgmt.servicenetworking.models.IpAccessRule]
    """

    rules: Optional[List["_models.IpAccessRule"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Ip Access Policy Rules List."""

    @overload
    def __init__(
        self,
        *,
        rules: Optional[List["_models.IpAccessRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpAccessRulesSecurityPolicy(_model_base.Model):
    """IpAccessRules Security Policy.

    :ivar id: Resource ID of the Ip Access Rules Security Policy. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource ID of the Ip Access Rules Security Policy. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.servicenetworking.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.servicenetworking.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.servicenetworking.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class ResourceId(_model_base.Model):
    """Resource ID definition used by parent to reference child resources.

    :ivar id: Resource ID of child resource. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource ID of child resource. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityPolicy(TrackedResource):
    """SecurityPolicy Subresource of Traffic Controller.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.SecurityPolicyProperties
    """

    properties: Optional["_models.SecurityPolicyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SecurityPolicyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityPolicyConfigurations(_model_base.Model):
    """SecurityPolicyConfigurations Subresource of Traffic Controller.

    :ivar waf_security_policy: Contains reference to a WAF-type security policy.
    :vartype waf_security_policy: ~azure.mgmt.servicenetworking.models.WafSecurityPolicy
    :ivar ip_access_rules_security_policy: Contains reference to a IpAccessRules-type security
     policy.
    :vartype ip_access_rules_security_policy:
     ~azure.mgmt.servicenetworking.models.IpAccessRulesSecurityPolicy
    """

    waf_security_policy: Optional["_models.WafSecurityPolicy"] = rest_field(
        name="wafSecurityPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains reference to a WAF-type security policy."""
    ip_access_rules_security_policy: Optional["_models.IpAccessRulesSecurityPolicy"] = rest_field(
        name="ipAccessRulesSecurityPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains reference to a IpAccessRules-type security policy."""

    @overload
    def __init__(
        self,
        *,
        waf_security_policy: Optional["_models.WafSecurityPolicy"] = None,
        ip_access_rules_security_policy: Optional["_models.IpAccessRulesSecurityPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityPolicyProperties(_model_base.Model):
    """SecurityPolicy Properties.

    :ivar policy_type: Type of the Traffic Controller Security Policy. Known values are: "waf" and
     "ipAccessRules".
    :vartype policy_type: str or ~azure.mgmt.servicenetworking.models.PolicyType
    :ivar waf_policy: Web Application Firewall Policy of the Traffic Controller Security Policy.
     Single Security Policy can have only one policy type set.
    :vartype waf_policy: ~azure.mgmt.servicenetworking.models.WafPolicy
    :ivar ip_access_rules_policy: Ip Access Policy of the Traffic Controller Security Policy.
     Single Security Policy can have only one policy type set.
    :vartype ip_access_rules_policy: ~azure.mgmt.servicenetworking.models.IpAccessRulesPolicy
    :ivar provisioning_state: Provisioning State of Traffic Controller SecurityPolicy Resource.
     Known values are: "Provisioning", "Updating", "Deleting", "Accepted", "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    policy_type: Optional[Union[str, "_models.PolicyType"]] = rest_field(name="policyType", visibility=["read"])
    """Type of the Traffic Controller Security Policy. Known values are: \"waf\" and
     \"ipAccessRules\"."""
    waf_policy: Optional["_models.WafPolicy"] = rest_field(
        name="wafPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Web Application Firewall Policy of the Traffic Controller Security Policy. Single Security
     Policy can have only one policy type set."""
    ip_access_rules_policy: Optional["_models.IpAccessRulesPolicy"] = rest_field(
        name="ipAccessRulesPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ip Access Policy of the Traffic Controller Security Policy. Single Security Policy can have
     only one policy type set."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of Traffic Controller SecurityPolicy Resource. Known values are:
     \"Provisioning\", \"Updating\", \"Deleting\", \"Accepted\", \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        waf_policy: Optional["_models.WafPolicy"] = None,
        ip_access_rules_policy: Optional["_models.IpAccessRulesPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityPolicyUpdate(_model_base.Model):
    """The type used for update operations of the SecurityPolicy.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.SecurityPolicyUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.SecurityPolicyUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SecurityPolicyUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityPolicyUpdateProperties(_model_base.Model):
    """The updatable properties of the SecurityPolicy.

    :ivar waf_policy: Web Application Firewall Policy of the Traffic Controller Security Policy.
     Single Security Policy can have only one policy type set.
    :vartype waf_policy: ~azure.mgmt.servicenetworking.models.WafPolicy
    :ivar ip_access_rules_policy: Ip Access Policy of the Traffic Controller Security Policy.
     Single Security Policy can have only one policy type set.
    :vartype ip_access_rules_policy: ~azure.mgmt.servicenetworking.models.IpAccessRulesPolicy
    """

    waf_policy: Optional["_models.WafPolicy"] = rest_field(
        name="wafPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Web Application Firewall Policy of the Traffic Controller Security Policy. Single Security
     Policy can have only one policy type set."""
    ip_access_rules_policy: Optional["_models.IpAccessRulesPolicy"] = rest_field(
        name="ipAccessRulesPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ip Access Policy of the Traffic Controller Security Policy. Single Security Policy can have
     only one policy type set."""

    @overload
    def __init__(
        self,
        *,
        waf_policy: Optional["_models.WafPolicy"] = None,
        ip_access_rules_policy: Optional["_models.IpAccessRulesPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.servicenetworking.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.servicenetworking.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrafficController(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.TrafficControllerProperties
    """

    properties: Optional["_models.TrafficControllerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.TrafficControllerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrafficControllerProperties(_model_base.Model):
    """Traffic Controller Properties.

    :ivar configuration_endpoints: Configuration Endpoints.
    :vartype configuration_endpoints: list[str]
    :ivar frontends: Frontends References List.
    :vartype frontends: list[~azure.mgmt.servicenetworking.models.ResourceId]
    :ivar associations: Associations References List.
    :vartype associations: list[~azure.mgmt.servicenetworking.models.ResourceId]
    :ivar security_policies: Security Policies References List.
    :vartype security_policies: list[~azure.mgmt.servicenetworking.models.ResourceId]
    :ivar security_policy_configurations: Security Policy Configuration.
    :vartype security_policy_configurations:
     ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurations
    :ivar provisioning_state: The status of the last operation. Known values are: "Provisioning",
     "Updating", "Deleting", "Accepted", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    configuration_endpoints: Optional[List[str]] = rest_field(name="configurationEndpoints", visibility=["read"])
    """Configuration Endpoints."""
    frontends: Optional[List["_models.ResourceId"]] = rest_field(visibility=["read"])
    """Frontends References List."""
    associations: Optional[List["_models.ResourceId"]] = rest_field(visibility=["read"])
    """Associations References List."""
    security_policies: Optional[List["_models.ResourceId"]] = rest_field(name="securityPolicies", visibility=["read"])
    """Security Policies References List."""
    security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = rest_field(
        name="securityPolicyConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Security Policy Configuration."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Provisioning\", \"Updating\",
     \"Deleting\", \"Accepted\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrafficControllerUpdate(_model_base.Model):
    """The type used for update operations of the TrafficController.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.servicenetworking.models.TrafficControllerUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.TrafficControllerUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.TrafficControllerUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrafficControllerUpdateProperties(_model_base.Model):
    """The updatable properties of the TrafficController.

    :ivar security_policy_configurations: Security Policy Configuration.
    :vartype security_policy_configurations:
     ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurations
    """

    security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = rest_field(
        name="securityPolicyConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Security Policy Configuration."""

    @overload
    def __init__(
        self,
        *,
        security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WafPolicy(_model_base.Model):
    """Web Application Firewall Policy.

    :ivar id: Resource ID of the WAF. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource ID of the WAF. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WafSecurityPolicy(_model_base.Model):
    """Web Application Firewall Security Policy.

    :ivar id: Resource ID of the Waf Security Policy. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource ID of the Waf Security Policy. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
