# Copyright (C) 2017 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This line is 'magic' in that git-cl looks for it to decide whether to
# use Python3 instead of Python2 when running the code in this file.
USE_PYTHON3 = True


def CommonChecks(input_api, output_api):
  presubmit_dir = input_api.PresubmitLocalPath()
  recipes_py = input_api.os_path.join(presubmit_dir, 'recipes.py')
  recipes_cfg = input_api.os_path.join(presubmit_dir, '..', 'config',
                                       'recipes.cfg')
  return input_api.RunTests([
      input_api.Command(
          'Run recipe tests',
          ['python3', recipes_py, '--package', recipes_cfg, 'test', 'run'],
          {},
          output_api.PresubmitError,
      )
  ])


def CheckChangeOnUpload(input_api, output_api):
  return CommonChecks(input_api, output_api)


def CheckChangeOnCommit(input_api, output_api):
  return CommonChecks(input_api, output_api)
