/*
 * AboutDialog.java
 *
 * Created on 28. Oktober 2006, 12:10
 */

package pauker.program.gui.swing;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;

/**
 *
 * @author Ronny.Standtke@gmx.net
 */
public class AboutDialog extends javax.swing.JDialog {

    private final static Logger logger =
            Logger.getLogger(AboutDialog.class.getName());

    /** Creates new form AboutDialog
     * @param parent the parent frame
     */
    public AboutDialog(Frame parent) {
        super(parent, true);

        initComponents();

        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");

        // update dialog title
        String versionString = bundle.getString("Pauker_Version");
        String title = MessageFormat.format(
                bundle.getString("ProgramTitle"), versionString);
        versionLabel.setText(title);

        Class thisClass = getClass();

        // load about infos from file
        String aboutFileName = bundle.getString("About_Message_File");
        URL fileURL = thisClass.getResource(aboutFileName);
        try {
            creditsEditorPane.setPage(fileURL);
        } catch (IOException ex) {
            logger.log(Level.SEVERE,
                    "could not load file with \"about\" info", ex);
        }

        // load license from file
        String licenseFileName = bundle.getString("License_File");
        fileURL = thisClass.getResource(licenseFileName);
        try {
            licenseEditorPane.setPage(fileURL);
        } catch (IOException ex) {
            logger.log(Level.SEVERE, "could not load license file", ex);
        }

        setLocationRelativeTo(parent);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Erzeugter Quelltext ">//GEN-BEGIN:initComponents
    private void initComponents() {
        versionLabel = new javax.swing.JLabel();
        tabbedPane = new javax.swing.JTabbedPane();
        creditsScrollPane = new javax.swing.JScrollPane();
        creditsEditorPane = new javax.swing.JEditorPane();
        licenseScrollPane = new javax.swing.JScrollPane();
        licenseEditorPane = new javax.swing.JEditorPane();
        okButtonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("pauker/Strings"); // NOI18N
        setTitle(bundle.getString("AboutDialogTitle")); // NOI18N
        versionLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pauker/icons/repeat.png")));
        versionLabel.setText(bundle.getString("ProgramTitle")); // NOI18N

        creditsEditorPane.setContentType("text/html");
        creditsEditorPane.setEditable(false);
        creditsEditorPane.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                creditsEditorPaneHyperlinkUpdate(evt);
            }
        });

        creditsScrollPane.setViewportView(creditsEditorPane);

        tabbedPane.addTab(bundle.getString("Credits"), creditsScrollPane); // NOI18N

        licenseEditorPane.setContentType("text/html");
        licenseEditorPane.setEditable(false);
        licenseEditorPane.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                licenseEditorPaneHyperlinkUpdate(evt);
            }
        });

        licenseScrollPane.setViewportView(licenseEditorPane);

        tabbedPane.addTab(bundle.getString("License"), licenseScrollPane); // NOI18N

        okButton.setText(bundle.getString("OK")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        okButtonPanel.add(okButton);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, tabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 510, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, versionLabel)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, okButtonPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 510, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(versionLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(tabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 440, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(okButtonPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void licenseEditorPaneHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_licenseEditorPaneHyperlinkUpdate
        openLink(evt);
    }//GEN-LAST:event_licenseEditorPaneHyperlinkUpdate

    private void creditsEditorPaneHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_creditsEditorPaneHyperlinkUpdate
        openLink(evt);
    }//GEN-LAST:event_creditsEditorPaneHyperlinkUpdate

    private void openLink(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() ==
                HyperlinkEvent.EventType.ACTIVATED) {

            PaukerFrame.openUrlInBrowser(hyperlinkEvent.getURL().toString());

            // disable and change cursor for a short time so that the user
            // has a visible feedback until the browser is open
            final JEditorPane source = (JEditorPane) hyperlinkEvent.getSource();
            Thread guiThread = new Thread() {

                @Override
                public void run() {
                    source.setEnabled(false);
                    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    try {
                        // just a wild guess
                        Thread.sleep(4000);
                    } catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    source.setEnabled(true);
                    setCursor(Cursor.getPredefinedCursor(
                            Cursor.DEFAULT_CURSOR));
                }
            };
            guiThread.start();
        }
    }

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose();
        setVisible(false);
    }//GEN-LAST:event_okButtonActionPerformed
    // Variablendeklaration - nicht modifizieren//GEN-BEGIN:variables
    private javax.swing.JEditorPane creditsEditorPane;
    private javax.swing.JScrollPane creditsScrollPane;
    private javax.swing.JEditorPane licenseEditorPane;
    private javax.swing.JScrollPane licenseScrollPane;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel okButtonPanel;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JLabel versionLabel;
    // Ende der Variablendeklaration//GEN-END:variables
}
