;;; Copyright (C) 2023, 2024 Igalia, S.L.
;;;
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;;
;;;    http://www.apache.org/licenses/LICENSE-2.0
;;;
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

;;; Commentary:
;;;
;;; Fluid tests.
;;;
;;; Code:

(use-modules (srfi srfi-64)
             (test utils))

(test-begin "test-fluids")

(with-additional-imports
 ((hoot fluids))
 (test-call "(42 (69 100) 42)"
            (lambda (f)
              (let* ((fluid (make-fluid 42))
                     (a (fluid-ref fluid))
                     (b (with-fluid* fluid 69 (lambda () (f fluid))))
                     (c (fluid-ref fluid)))
                (list a b c)))
            (lambda (fluid)
              (let ((v (fluid-ref fluid)))
                (fluid-set! fluid 100)
                (list v (fluid-ref fluid))))))

(with-additional-imports
 ((hoot fluids)
  (hoot dynamic-states))
 (test-call "#t"
            (lambda ()
              (dynamic-state? (current-dynamic-state)))))

(with-additional-imports
 ((hoot fluids)
  (hoot dynamic-states))
 (test-call "(42 42 69 42)"
            (lambda ()
              (let* ((fluid (make-fluid 42))
                     (a (fluid-ref fluid))
                     (b (with-fluid* fluid 69
                          (lambda () (current-dynamic-state))))
                     (c (fluid-ref fluid))
                     (d (with-dynamic-state b (lambda () (fluid-ref fluid))))
                     (e (fluid-ref fluid)))
                (list a c d e)))))

(with-additional-imports
  ((hoot fluids))
  (test-call "3"
             (lambda ()
               (let* ((fluid1 (make-fluid 42))
                      (fluid2 (make-fluid 77)))
                 (with-fluids* (list fluid1 fluid2) (list 10 7)
                   (lambda () (- (fluid-ref fluid1) (fluid-ref fluid2))))))))

(test-end* "test-fluids")
