package madmin

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"time"

	"github.com/tinylib/msgp/msgp"
)

// DecodeMsg implements msgp.Decodable
func (z *BucketTarget) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	var zb0001Mask uint16 /* 10 bits */
	_ = zb0001Mask
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "sourcebucket":
			z.SourceBucket, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SourceBucket")
				return
			}
		case "endpoint":
			z.Endpoint, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Endpoint")
				return
			}
		case "credentials":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Credentials")
					return
				}
				z.Credentials = nil
			} else {
				if z.Credentials == nil {
					z.Credentials = new(Credentials)
				}
				err = z.Credentials.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Credentials")
					return
				}
			}
		case "targetbucket":
			z.TargetBucket, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "TargetBucket")
				return
			}
		case "secure":
			z.Secure, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Secure")
				return
			}
		case "path":
			z.Path, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Path")
				return
			}
			zb0001Mask |= 0x1
		case "api":
			z.API, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "API")
				return
			}
			zb0001Mask |= 0x2
		case "arn":
			z.Arn, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Arn")
				return
			}
			zb0001Mask |= 0x4
		case "type":
			{
				var zb0002 string
				zb0002, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Type")
					return
				}
				z.Type = ServiceType(zb0002)
			}
		case "region":
			z.Region, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Region")
				return
			}
			zb0001Mask |= 0x8
		case "bandwidthlimit":
			z.BandwidthLimit, err = dc.ReadInt64()
			if err != nil {
				err = msgp.WrapError(err, "BandwidthLimit")
				return
			}
			zb0001Mask |= 0x10
		case "replicationSync":
			z.ReplicationSync, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "ReplicationSync")
				return
			}
		case "storageclass":
			z.StorageClass, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
			zb0001Mask |= 0x20
		case "healthCheckDuration":
			z.HealthCheckDuration, err = dc.ReadDuration()
			if err != nil {
				err = msgp.WrapError(err, "HealthCheckDuration")
				return
			}
			zb0001Mask |= 0x40
		case "disableProxy":
			z.DisableProxy, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "DisableProxy")
				return
			}
		case "resetBeforeDate":
			z.ResetBeforeDate, err = dc.ReadTime()
			if err != nil {
				err = msgp.WrapError(err, "ResetBeforeDate")
				return
			}
			zb0001Mask |= 0x80
		case "resetID":
			z.ResetID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "ResetID")
				return
			}
			zb0001Mask |= 0x100
		case "totalDowntime":
			z.TotalDowntime, err = dc.ReadDuration()
			if err != nil {
				err = msgp.WrapError(err, "TotalDowntime")
				return
			}
		case "lastOnline":
			z.LastOnline, err = dc.ReadTime()
			if err != nil {
				err = msgp.WrapError(err, "LastOnline")
				return
			}
		case "isOnline":
			z.Online, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Online")
				return
			}
		case "latency":
			err = z.Latency.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "Latency")
				return
			}
		case "deploymentID":
			z.DeploymentID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DeploymentID")
				return
			}
			zb0001Mask |= 0x200
		case "edge":
			z.Edge, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Edge")
				return
			}
		case "edgeSyncBeforeExpiry":
			z.EdgeSyncBeforeExpiry, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "EdgeSyncBeforeExpiry")
				return
			}
		case "offlineCount":
			z.OfflineCount, err = dc.ReadInt64()
			if err != nil {
				err = msgp.WrapError(err, "OfflineCount")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	// Clear omitted fields.
	if zb0001Mask != 0x3ff {
		if (zb0001Mask & 0x1) == 0 {
			z.Path = ""
		}
		if (zb0001Mask & 0x2) == 0 {
			z.API = ""
		}
		if (zb0001Mask & 0x4) == 0 {
			z.Arn = ""
		}
		if (zb0001Mask & 0x8) == 0 {
			z.Region = ""
		}
		if (zb0001Mask & 0x10) == 0 {
			z.BandwidthLimit = 0
		}
		if (zb0001Mask & 0x20) == 0 {
			z.StorageClass = ""
		}
		if (zb0001Mask & 0x40) == 0 {
			z.HealthCheckDuration = 0
		}
		if (zb0001Mask & 0x80) == 0 {
			z.ResetBeforeDate = (time.Time{})
		}
		if (zb0001Mask & 0x100) == 0 {
			z.ResetID = ""
		}
		if (zb0001Mask & 0x200) == 0 {
			z.DeploymentID = ""
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *BucketTarget) EncodeMsg(en *msgp.Writer) (err error) {
	// check for omitted fields
	zb0001Len := uint32(25)
	var zb0001Mask uint32 /* 25 bits */
	_ = zb0001Mask
	if z.Path == "" {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if z.API == "" {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if z.Arn == "" {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if z.Region == "" {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if z.BandwidthLimit == 0 {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if z.StorageClass == "" {
		zb0001Len--
		zb0001Mask |= 0x1000
	}
	if z.HealthCheckDuration == 0 {
		zb0001Len--
		zb0001Mask |= 0x2000
	}
	if z.ResetBeforeDate == (time.Time{}) {
		zb0001Len--
		zb0001Mask |= 0x8000
	}
	if z.ResetID == "" {
		zb0001Len--
		zb0001Mask |= 0x10000
	}
	if z.DeploymentID == "" {
		zb0001Len--
		zb0001Mask |= 0x200000
	}
	// variable map header, size zb0001Len
	err = en.WriteMapHeader(zb0001Len)
	if err != nil {
		return
	}

	// skip if no fields are to be emitted
	if zb0001Len != 0 {
		// write "sourcebucket"
		err = en.Append(0xac, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.SourceBucket)
		if err != nil {
			err = msgp.WrapError(err, "SourceBucket")
			return
		}
		// write "endpoint"
		err = en.Append(0xa8, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.Endpoint)
		if err != nil {
			err = msgp.WrapError(err, "Endpoint")
			return
		}
		// write "credentials"
		err = en.Append(0xab, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73)
		if err != nil {
			return
		}
		if z.Credentials == nil {
			err = en.WriteNil()
			if err != nil {
				return
			}
		} else {
			err = z.Credentials.EncodeMsg(en)
			if err != nil {
				err = msgp.WrapError(err, "Credentials")
				return
			}
		}
		// write "targetbucket"
		err = en.Append(0xac, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.TargetBucket)
		if err != nil {
			err = msgp.WrapError(err, "TargetBucket")
			return
		}
		// write "secure"
		err = en.Append(0xa6, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65)
		if err != nil {
			return
		}
		err = en.WriteBool(z.Secure)
		if err != nil {
			err = msgp.WrapError(err, "Secure")
			return
		}
		if (zb0001Mask & 0x20) == 0 { // if not omitted
			// write "path"
			err = en.Append(0xa4, 0x70, 0x61, 0x74, 0x68)
			if err != nil {
				return
			}
			err = en.WriteString(z.Path)
			if err != nil {
				err = msgp.WrapError(err, "Path")
				return
			}
		}
		if (zb0001Mask & 0x40) == 0 { // if not omitted
			// write "api"
			err = en.Append(0xa3, 0x61, 0x70, 0x69)
			if err != nil {
				return
			}
			err = en.WriteString(z.API)
			if err != nil {
				err = msgp.WrapError(err, "API")
				return
			}
		}
		if (zb0001Mask & 0x80) == 0 { // if not omitted
			// write "arn"
			err = en.Append(0xa3, 0x61, 0x72, 0x6e)
			if err != nil {
				return
			}
			err = en.WriteString(z.Arn)
			if err != nil {
				err = msgp.WrapError(err, "Arn")
				return
			}
		}
		// write "type"
		err = en.Append(0xa4, 0x74, 0x79, 0x70, 0x65)
		if err != nil {
			return
		}
		err = en.WriteString(string(z.Type))
		if err != nil {
			err = msgp.WrapError(err, "Type")
			return
		}
		if (zb0001Mask & 0x200) == 0 { // if not omitted
			// write "region"
			err = en.Append(0xa6, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e)
			if err != nil {
				return
			}
			err = en.WriteString(z.Region)
			if err != nil {
				err = msgp.WrapError(err, "Region")
				return
			}
		}
		if (zb0001Mask & 0x400) == 0 { // if not omitted
			// write "bandwidthlimit"
			err = en.Append(0xae, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x6c, 0x69, 0x6d, 0x69, 0x74)
			if err != nil {
				return
			}
			err = en.WriteInt64(z.BandwidthLimit)
			if err != nil {
				err = msgp.WrapError(err, "BandwidthLimit")
				return
			}
		}
		// write "replicationSync"
		err = en.Append(0xaf, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x6e, 0x63)
		if err != nil {
			return
		}
		err = en.WriteBool(z.ReplicationSync)
		if err != nil {
			err = msgp.WrapError(err, "ReplicationSync")
			return
		}
		if (zb0001Mask & 0x1000) == 0 { // if not omitted
			// write "storageclass"
			err = en.Append(0xac, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x63, 0x6c, 0x61, 0x73, 0x73)
			if err != nil {
				return
			}
			err = en.WriteString(z.StorageClass)
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
		}
		if (zb0001Mask & 0x2000) == 0 { // if not omitted
			// write "healthCheckDuration"
			err = en.Append(0xb3, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e)
			if err != nil {
				return
			}
			err = en.WriteDuration(z.HealthCheckDuration)
			if err != nil {
				err = msgp.WrapError(err, "HealthCheckDuration")
				return
			}
		}
		// write "disableProxy"
		err = en.Append(0xac, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79)
		if err != nil {
			return
		}
		err = en.WriteBool(z.DisableProxy)
		if err != nil {
			err = msgp.WrapError(err, "DisableProxy")
			return
		}
		if (zb0001Mask & 0x8000) == 0 { // if not omitted
			// write "resetBeforeDate"
			err = en.Append(0xaf, 0x72, 0x65, 0x73, 0x65, 0x74, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x65)
			if err != nil {
				return
			}
			err = en.WriteTime(z.ResetBeforeDate)
			if err != nil {
				err = msgp.WrapError(err, "ResetBeforeDate")
				return
			}
		}
		if (zb0001Mask & 0x10000) == 0 { // if not omitted
			// write "resetID"
			err = en.Append(0xa7, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x44)
			if err != nil {
				return
			}
			err = en.WriteString(z.ResetID)
			if err != nil {
				err = msgp.WrapError(err, "ResetID")
				return
			}
		}
		// write "totalDowntime"
		err = en.Append(0xad, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x6f, 0x77, 0x6e, 0x74, 0x69, 0x6d, 0x65)
		if err != nil {
			return
		}
		err = en.WriteDuration(z.TotalDowntime)
		if err != nil {
			err = msgp.WrapError(err, "TotalDowntime")
			return
		}
		// write "lastOnline"
		err = en.Append(0xaa, 0x6c, 0x61, 0x73, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65)
		if err != nil {
			return
		}
		err = en.WriteTime(z.LastOnline)
		if err != nil {
			err = msgp.WrapError(err, "LastOnline")
			return
		}
		// write "isOnline"
		err = en.Append(0xa8, 0x69, 0x73, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65)
		if err != nil {
			return
		}
		err = en.WriteBool(z.Online)
		if err != nil {
			err = msgp.WrapError(err, "Online")
			return
		}
		// write "latency"
		err = en.Append(0xa7, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79)
		if err != nil {
			return
		}
		err = z.Latency.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Latency")
			return
		}
		if (zb0001Mask & 0x200000) == 0 { // if not omitted
			// write "deploymentID"
			err = en.Append(0xac, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x44)
			if err != nil {
				return
			}
			err = en.WriteString(z.DeploymentID)
			if err != nil {
				err = msgp.WrapError(err, "DeploymentID")
				return
			}
		}
		// write "edge"
		err = en.Append(0xa4, 0x65, 0x64, 0x67, 0x65)
		if err != nil {
			return
		}
		err = en.WriteBool(z.Edge)
		if err != nil {
			err = msgp.WrapError(err, "Edge")
			return
		}
		// write "edgeSyncBeforeExpiry"
		err = en.Append(0xb4, 0x65, 0x64, 0x67, 0x65, 0x53, 0x79, 0x6e, 0x63, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79)
		if err != nil {
			return
		}
		err = en.WriteBool(z.EdgeSyncBeforeExpiry)
		if err != nil {
			err = msgp.WrapError(err, "EdgeSyncBeforeExpiry")
			return
		}
		// write "offlineCount"
		err = en.Append(0xac, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74)
		if err != nil {
			return
		}
		err = en.WriteInt64(z.OfflineCount)
		if err != nil {
			err = msgp.WrapError(err, "OfflineCount")
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BucketTarget) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// check for omitted fields
	zb0001Len := uint32(25)
	var zb0001Mask uint32 /* 25 bits */
	_ = zb0001Mask
	if z.Path == "" {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if z.API == "" {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if z.Arn == "" {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if z.Region == "" {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if z.BandwidthLimit == 0 {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if z.StorageClass == "" {
		zb0001Len--
		zb0001Mask |= 0x1000
	}
	if z.HealthCheckDuration == 0 {
		zb0001Len--
		zb0001Mask |= 0x2000
	}
	if z.ResetBeforeDate == (time.Time{}) {
		zb0001Len--
		zb0001Mask |= 0x8000
	}
	if z.ResetID == "" {
		zb0001Len--
		zb0001Mask |= 0x10000
	}
	if z.DeploymentID == "" {
		zb0001Len--
		zb0001Mask |= 0x200000
	}
	// variable map header, size zb0001Len
	o = msgp.AppendMapHeader(o, zb0001Len)

	// skip if no fields are to be emitted
	if zb0001Len != 0 {
		// string "sourcebucket"
		o = append(o, 0xac, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74)
		o = msgp.AppendString(o, z.SourceBucket)
		// string "endpoint"
		o = append(o, 0xa8, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74)
		o = msgp.AppendString(o, z.Endpoint)
		// string "credentials"
		o = append(o, 0xab, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73)
		if z.Credentials == nil {
			o = msgp.AppendNil(o)
		} else {
			o, err = z.Credentials.MarshalMsg(o)
			if err != nil {
				err = msgp.WrapError(err, "Credentials")
				return
			}
		}
		// string "targetbucket"
		o = append(o, 0xac, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74)
		o = msgp.AppendString(o, z.TargetBucket)
		// string "secure"
		o = append(o, 0xa6, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65)
		o = msgp.AppendBool(o, z.Secure)
		if (zb0001Mask & 0x20) == 0 { // if not omitted
			// string "path"
			o = append(o, 0xa4, 0x70, 0x61, 0x74, 0x68)
			o = msgp.AppendString(o, z.Path)
		}
		if (zb0001Mask & 0x40) == 0 { // if not omitted
			// string "api"
			o = append(o, 0xa3, 0x61, 0x70, 0x69)
			o = msgp.AppendString(o, z.API)
		}
		if (zb0001Mask & 0x80) == 0 { // if not omitted
			// string "arn"
			o = append(o, 0xa3, 0x61, 0x72, 0x6e)
			o = msgp.AppendString(o, z.Arn)
		}
		// string "type"
		o = append(o, 0xa4, 0x74, 0x79, 0x70, 0x65)
		o = msgp.AppendString(o, string(z.Type))
		if (zb0001Mask & 0x200) == 0 { // if not omitted
			// string "region"
			o = append(o, 0xa6, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e)
			o = msgp.AppendString(o, z.Region)
		}
		if (zb0001Mask & 0x400) == 0 { // if not omitted
			// string "bandwidthlimit"
			o = append(o, 0xae, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x6c, 0x69, 0x6d, 0x69, 0x74)
			o = msgp.AppendInt64(o, z.BandwidthLimit)
		}
		// string "replicationSync"
		o = append(o, 0xaf, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x6e, 0x63)
		o = msgp.AppendBool(o, z.ReplicationSync)
		if (zb0001Mask & 0x1000) == 0 { // if not omitted
			// string "storageclass"
			o = append(o, 0xac, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x63, 0x6c, 0x61, 0x73, 0x73)
			o = msgp.AppendString(o, z.StorageClass)
		}
		if (zb0001Mask & 0x2000) == 0 { // if not omitted
			// string "healthCheckDuration"
			o = append(o, 0xb3, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e)
			o = msgp.AppendDuration(o, z.HealthCheckDuration)
		}
		// string "disableProxy"
		o = append(o, 0xac, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79)
		o = msgp.AppendBool(o, z.DisableProxy)
		if (zb0001Mask & 0x8000) == 0 { // if not omitted
			// string "resetBeforeDate"
			o = append(o, 0xaf, 0x72, 0x65, 0x73, 0x65, 0x74, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x65)
			o = msgp.AppendTime(o, z.ResetBeforeDate)
		}
		if (zb0001Mask & 0x10000) == 0 { // if not omitted
			// string "resetID"
			o = append(o, 0xa7, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x44)
			o = msgp.AppendString(o, z.ResetID)
		}
		// string "totalDowntime"
		o = append(o, 0xad, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x6f, 0x77, 0x6e, 0x74, 0x69, 0x6d, 0x65)
		o = msgp.AppendDuration(o, z.TotalDowntime)
		// string "lastOnline"
		o = append(o, 0xaa, 0x6c, 0x61, 0x73, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65)
		o = msgp.AppendTime(o, z.LastOnline)
		// string "isOnline"
		o = append(o, 0xa8, 0x69, 0x73, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65)
		o = msgp.AppendBool(o, z.Online)
		// string "latency"
		o = append(o, 0xa7, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79)
		o, err = z.Latency.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Latency")
			return
		}
		if (zb0001Mask & 0x200000) == 0 { // if not omitted
			// string "deploymentID"
			o = append(o, 0xac, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x44)
			o = msgp.AppendString(o, z.DeploymentID)
		}
		// string "edge"
		o = append(o, 0xa4, 0x65, 0x64, 0x67, 0x65)
		o = msgp.AppendBool(o, z.Edge)
		// string "edgeSyncBeforeExpiry"
		o = append(o, 0xb4, 0x65, 0x64, 0x67, 0x65, 0x53, 0x79, 0x6e, 0x63, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79)
		o = msgp.AppendBool(o, z.EdgeSyncBeforeExpiry)
		// string "offlineCount"
		o = append(o, 0xac, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74)
		o = msgp.AppendInt64(o, z.OfflineCount)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BucketTarget) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	var zb0001Mask uint16 /* 10 bits */
	_ = zb0001Mask
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "sourcebucket":
			z.SourceBucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SourceBucket")
				return
			}
		case "endpoint":
			z.Endpoint, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Endpoint")
				return
			}
		case "credentials":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Credentials = nil
			} else {
				if z.Credentials == nil {
					z.Credentials = new(Credentials)
				}
				bts, err = z.Credentials.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Credentials")
					return
				}
			}
		case "targetbucket":
			z.TargetBucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TargetBucket")
				return
			}
		case "secure":
			z.Secure, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Secure")
				return
			}
		case "path":
			z.Path, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Path")
				return
			}
			zb0001Mask |= 0x1
		case "api":
			z.API, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "API")
				return
			}
			zb0001Mask |= 0x2
		case "arn":
			z.Arn, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Arn")
				return
			}
			zb0001Mask |= 0x4
		case "type":
			{
				var zb0002 string
				zb0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Type")
					return
				}
				z.Type = ServiceType(zb0002)
			}
		case "region":
			z.Region, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Region")
				return
			}
			zb0001Mask |= 0x8
		case "bandwidthlimit":
			z.BandwidthLimit, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "BandwidthLimit")
				return
			}
			zb0001Mask |= 0x10
		case "replicationSync":
			z.ReplicationSync, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationSync")
				return
			}
		case "storageclass":
			z.StorageClass, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
			zb0001Mask |= 0x20
		case "healthCheckDuration":
			z.HealthCheckDuration, bts, err = msgp.ReadDurationBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "HealthCheckDuration")
				return
			}
			zb0001Mask |= 0x40
		case "disableProxy":
			z.DisableProxy, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DisableProxy")
				return
			}
		case "resetBeforeDate":
			z.ResetBeforeDate, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ResetBeforeDate")
				return
			}
			zb0001Mask |= 0x80
		case "resetID":
			z.ResetID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ResetID")
				return
			}
			zb0001Mask |= 0x100
		case "totalDowntime":
			z.TotalDowntime, bts, err = msgp.ReadDurationBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TotalDowntime")
				return
			}
		case "lastOnline":
			z.LastOnline, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "LastOnline")
				return
			}
		case "isOnline":
			z.Online, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Online")
				return
			}
		case "latency":
			bts, err = z.Latency.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "Latency")
				return
			}
		case "deploymentID":
			z.DeploymentID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DeploymentID")
				return
			}
			zb0001Mask |= 0x200
		case "edge":
			z.Edge, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Edge")
				return
			}
		case "edgeSyncBeforeExpiry":
			z.EdgeSyncBeforeExpiry, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "EdgeSyncBeforeExpiry")
				return
			}
		case "offlineCount":
			z.OfflineCount, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "OfflineCount")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	// Clear omitted fields.
	if zb0001Mask != 0x3ff {
		if (zb0001Mask & 0x1) == 0 {
			z.Path = ""
		}
		if (zb0001Mask & 0x2) == 0 {
			z.API = ""
		}
		if (zb0001Mask & 0x4) == 0 {
			z.Arn = ""
		}
		if (zb0001Mask & 0x8) == 0 {
			z.Region = ""
		}
		if (zb0001Mask & 0x10) == 0 {
			z.BandwidthLimit = 0
		}
		if (zb0001Mask & 0x20) == 0 {
			z.StorageClass = ""
		}
		if (zb0001Mask & 0x40) == 0 {
			z.HealthCheckDuration = 0
		}
		if (zb0001Mask & 0x80) == 0 {
			z.ResetBeforeDate = (time.Time{})
		}
		if (zb0001Mask & 0x100) == 0 {
			z.ResetID = ""
		}
		if (zb0001Mask & 0x200) == 0 {
			z.DeploymentID = ""
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BucketTarget) Msgsize() (s int) {
	s = 3 + 13 + msgp.StringPrefixSize + len(z.SourceBucket) + 9 + msgp.StringPrefixSize + len(z.Endpoint) + 12
	if z.Credentials == nil {
		s += msgp.NilSize
	} else {
		s += z.Credentials.Msgsize()
	}
	s += 13 + msgp.StringPrefixSize + len(z.TargetBucket) + 7 + msgp.BoolSize + 5 + msgp.StringPrefixSize + len(z.Path) + 4 + msgp.StringPrefixSize + len(z.API) + 4 + msgp.StringPrefixSize + len(z.Arn) + 5 + msgp.StringPrefixSize + len(string(z.Type)) + 7 + msgp.StringPrefixSize + len(z.Region) + 15 + msgp.Int64Size + 16 + msgp.BoolSize + 13 + msgp.StringPrefixSize + len(z.StorageClass) + 20 + msgp.DurationSize + 13 + msgp.BoolSize + 16 + msgp.TimeSize + 8 + msgp.StringPrefixSize + len(z.ResetID) + 14 + msgp.DurationSize + 11 + msgp.TimeSize + 9 + msgp.BoolSize + 8 + z.Latency.Msgsize() + 13 + msgp.StringPrefixSize + len(z.DeploymentID) + 5 + msgp.BoolSize + 21 + msgp.BoolSize + 13 + msgp.Int64Size
	return
}

// DecodeMsg implements msgp.Decodable
func (z *BucketTargets) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "targets":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Targets")
				return
			}
			if cap(z.Targets) >= int(zb0002) {
				z.Targets = (z.Targets)[:zb0002]
			} else {
				z.Targets = make([]BucketTarget, zb0002)
			}
			for za0001 := range z.Targets {
				err = z.Targets[za0001].DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Targets", za0001)
					return
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *BucketTargets) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "targets"
	err = en.Append(0x81, 0xa7, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Targets)))
	if err != nil {
		err = msgp.WrapError(err, "Targets")
		return
	}
	for za0001 := range z.Targets {
		err = z.Targets[za0001].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Targets", za0001)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BucketTargets) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "targets"
	o = append(o, 0x81, 0xa7, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Targets)))
	for za0001 := range z.Targets {
		o, err = z.Targets[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Targets", za0001)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BucketTargets) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "targets":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Targets")
				return
			}
			if cap(z.Targets) >= int(zb0002) {
				z.Targets = (z.Targets)[:zb0002]
			} else {
				z.Targets = make([]BucketTarget, zb0002)
			}
			for za0001 := range z.Targets {
				bts, err = z.Targets[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Targets", za0001)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BucketTargets) Msgsize() (s int) {
	s = 1 + 8 + msgp.ArrayHeaderSize
	for za0001 := range z.Targets {
		s += z.Targets[za0001].Msgsize()
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *Credentials) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	var zb0001Mask uint8 /* 4 bits */
	_ = zb0001Mask
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "accessKey":
			z.AccessKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "AccessKey")
				return
			}
			zb0001Mask |= 0x1
		case "secretKey":
			z.SecretKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SecretKey")
				return
			}
			zb0001Mask |= 0x2
		case "sessionToken":
			z.SessionToken, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SessionToken")
				return
			}
			zb0001Mask |= 0x4
		case "expiration":
			z.Expiration, err = dc.ReadTime()
			if err != nil {
				err = msgp.WrapError(err, "Expiration")
				return
			}
			zb0001Mask |= 0x8
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	// Clear omitted fields.
	if zb0001Mask != 0xf {
		if (zb0001Mask & 0x1) == 0 {
			z.AccessKey = ""
		}
		if (zb0001Mask & 0x2) == 0 {
			z.SecretKey = ""
		}
		if (zb0001Mask & 0x4) == 0 {
			z.SessionToken = ""
		}
		if (zb0001Mask & 0x8) == 0 {
			z.Expiration = (time.Time{})
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *Credentials) EncodeMsg(en *msgp.Writer) (err error) {
	// check for omitted fields
	zb0001Len := uint32(4)
	var zb0001Mask uint8 /* 4 bits */
	_ = zb0001Mask
	if z.AccessKey == "" {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if z.SecretKey == "" {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if z.SessionToken == "" {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if z.Expiration == (time.Time{}) {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	err = en.Append(0x80 | uint8(zb0001Len))
	if err != nil {
		return
	}

	// skip if no fields are to be emitted
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not omitted
			// write "accessKey"
			err = en.Append(0xa9, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79)
			if err != nil {
				return
			}
			err = en.WriteString(z.AccessKey)
			if err != nil {
				err = msgp.WrapError(err, "AccessKey")
				return
			}
		}
		if (zb0001Mask & 0x2) == 0 { // if not omitted
			// write "secretKey"
			err = en.Append(0xa9, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79)
			if err != nil {
				return
			}
			err = en.WriteString(z.SecretKey)
			if err != nil {
				err = msgp.WrapError(err, "SecretKey")
				return
			}
		}
		if (zb0001Mask & 0x4) == 0 { // if not omitted
			// write "sessionToken"
			err = en.Append(0xac, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e)
			if err != nil {
				return
			}
			err = en.WriteString(z.SessionToken)
			if err != nil {
				err = msgp.WrapError(err, "SessionToken")
				return
			}
		}
		if (zb0001Mask & 0x8) == 0 { // if not omitted
			// write "expiration"
			err = en.Append(0xaa, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e)
			if err != nil {
				return
			}
			err = en.WriteTime(z.Expiration)
			if err != nil {
				err = msgp.WrapError(err, "Expiration")
				return
			}
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Credentials) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// check for omitted fields
	zb0001Len := uint32(4)
	var zb0001Mask uint8 /* 4 bits */
	_ = zb0001Mask
	if z.AccessKey == "" {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if z.SecretKey == "" {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if z.SessionToken == "" {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if z.Expiration == (time.Time{}) {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))

	// skip if no fields are to be emitted
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not omitted
			// string "accessKey"
			o = append(o, 0xa9, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79)
			o = msgp.AppendString(o, z.AccessKey)
		}
		if (zb0001Mask & 0x2) == 0 { // if not omitted
			// string "secretKey"
			o = append(o, 0xa9, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79)
			o = msgp.AppendString(o, z.SecretKey)
		}
		if (zb0001Mask & 0x4) == 0 { // if not omitted
			// string "sessionToken"
			o = append(o, 0xac, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e)
			o = msgp.AppendString(o, z.SessionToken)
		}
		if (zb0001Mask & 0x8) == 0 { // if not omitted
			// string "expiration"
			o = append(o, 0xaa, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e)
			o = msgp.AppendTime(o, z.Expiration)
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Credentials) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	var zb0001Mask uint8 /* 4 bits */
	_ = zb0001Mask
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "accessKey":
			z.AccessKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AccessKey")
				return
			}
			zb0001Mask |= 0x1
		case "secretKey":
			z.SecretKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SecretKey")
				return
			}
			zb0001Mask |= 0x2
		case "sessionToken":
			z.SessionToken, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SessionToken")
				return
			}
			zb0001Mask |= 0x4
		case "expiration":
			z.Expiration, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Expiration")
				return
			}
			zb0001Mask |= 0x8
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	// Clear omitted fields.
	if zb0001Mask != 0xf {
		if (zb0001Mask & 0x1) == 0 {
			z.AccessKey = ""
		}
		if (zb0001Mask & 0x2) == 0 {
			z.SecretKey = ""
		}
		if (zb0001Mask & 0x4) == 0 {
			z.SessionToken = ""
		}
		if (zb0001Mask & 0x8) == 0 {
			z.Expiration = (time.Time{})
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Credentials) Msgsize() (s int) {
	s = 1 + 10 + msgp.StringPrefixSize + len(z.AccessKey) + 10 + msgp.StringPrefixSize + len(z.SecretKey) + 13 + msgp.StringPrefixSize + len(z.SessionToken) + 11 + msgp.TimeSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *ServiceType) DecodeMsg(dc *msgp.Reader) (err error) {
	{
		var zb0001 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = ServiceType(zb0001)
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z ServiceType) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteString(string(z))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z ServiceType) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ServiceType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = ServiceType(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z ServiceType) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}
