import { Data } from "@ot-builder/prelude";
import * as CffInterp from "../../interp/ir";
export declare enum MirType {
    Nop = 0,
    Operand = 1,
    Operator = 2,
    NonTerminal = 3
}
export interface MirShared {
    readonly stackRise: number;
    readonly stackRidge: number;
}
export type MirNop = {
    type: MirType.Nop;
} & MirShared;
export type MirOperand = {
    type: MirType.Operand;
    arg: number;
} & MirShared;
export type MirOperator = {
    type: MirType.Operator;
    opCode: number;
    flags?: Data.Maybe<number[]>;
} & MirShared;
export type MirNonTerminal = {
    type: MirType.NonTerminal;
    id: number;
} & MirShared;
export type Mir = MirNop | MirOperand | MirOperator | MirNonTerminal;
export declare namespace Mir {
    function nop(): MirNop;
    function operand(x: number): MirOperand;
    function operator(opCode: number, sr: number, flags?: Data.Maybe<number[]>): MirOperator;
    function isNonTerminal(ir: Mir): ir is MirNonTerminal;
    function rectifyMirStr(s: string): string;
    function printCharString(mirSeq: Iterable<Mir>): string;
    function toInterpIrSeq(mirSeq: Iterable<Mir>): Generator<CffInterp.Operator | CffInterp.Operand, void, unknown>;
}
//# sourceMappingURL=mir.d.ts.map