/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import mso.generator.JavaParserGenerator;
import mso.generator.QtApiGenerator;
import mso.generator.QtParserGenerator;
import mso.generator.utils.MSO;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ParserGeneratorRunner {
    static final String version = ParserGeneratorRunner.getVersion();

    private static String getVersion() {
        String string = "unknown";
        Properties properties = new Properties();
        try {
            InputStream inputStream = ParserGeneratorRunner.open("version.properties");
            properties.load(inputStream);
            inputStream.close();
            string = properties.getProperty("version");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        new File("src/mso/javaparser").mkdirs();
        Validator validator = ParserGeneratorRunner.createValidator("mso.xsd");
        ParserGeneratorRunner.generate(validator, "mso.xml", "MSO", "cpp");
    }

    private static void generate(Validator validator, String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException, Exception {
        validator.validate(new StreamSource(ParserGeneratorRunner.open(string)));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ParserGeneratorRunner.open(string));
        MSO mSO = MSO.parse(document);
        new File(string3).mkdirs();
        ParserGeneratorRunner.generateJavaParser(mSO, string2);
        ParserGeneratorRunner.generateQtParser(mSO, "", "generatedclasses", string3);
        ParserGeneratorRunner.generateSimpleQtParser(mSO, string2, "simpleParser", string3);
        ParserGeneratorRunner.generateApi(mSO, string2, "api", string3);
    }

    private static void generateJavaParser(MSO mSO, String string) throws IOException {
        JavaParserGenerator javaParserGenerator = new JavaParserGenerator();
        String string2 = string.toLowerCase();
        String string3 = string.substring(0, 1) + string2.substring(1);
        javaParserGenerator.generate(mSO, "src", string2 + ".javaparser", "Generated" + string3 + "Parser");
    }

    private static void generateQtParser(MSO mSO, String string, String string2, String string3) throws IOException {
        QtParserGenerator qtParserGenerator = new QtParserGenerator(string, string2, string3);
        qtParserGenerator.config.createHeader = false;
        qtParserGenerator.config.enableIntrospection = true;
        qtParserGenerator.config.enableXml = true;
        qtParserGenerator.config.enableWriting = true;
        qtParserGenerator.config.enableToString = true;
        qtParserGenerator.config.enableStyleTextPropAtomFix = false;
        qtParserGenerator.generate(mSO);
    }

    private static void generateSimpleQtParser(MSO mSO, String string, String string2, String string3) throws IOException {
        QtParserGenerator qtParserGenerator = new QtParserGenerator(string, string2, string3);
        qtParserGenerator.config.createHeader = true;
        qtParserGenerator.config.enableIntrospection = false;
        qtParserGenerator.config.enableXml = false;
        qtParserGenerator.config.enableWriting = false;
        qtParserGenerator.config.enableToString = false;
        qtParserGenerator.config.enableStyleTextPropAtomFix = true;
        qtParserGenerator.generate(mSO);
    }

    private static void generateApi(MSO mSO, String string, String string2, String string3) throws IOException {
        QtApiGenerator qtApiGenerator = new QtApiGenerator(string, string2, string3);
        qtApiGenerator.config.createHeader = true;
        qtApiGenerator.generate(mSO);
    }

    private static InputStream open(String string) throws Exception {
        File file = new File(string);
        if (file.canRead()) {
            System.out.println("Reading " + file.getAbsolutePath());
            return new FileInputStream(file.getAbsolutePath());
        }
        file = new File("src/" + string);
        if (file.canRead()) {
            System.out.println("Reading " + file.getAbsolutePath());
            return new FileInputStream(file.getAbsolutePath());
        }
        System.out.println("Reading " + string + " from jar file.");
        return ParserGeneratorRunner.class.getResourceAsStream("/" + string);
    }

    private static Validator createValidator(String string) throws Exception {
        String string2 = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
        Source[] sourceArray = new Source[]{new StreamSource(ParserGeneratorRunner.open(string))};
        Schema schema = schemaFactory.newSchema(sourceArray);
        return schema.newValidator();
    }
}

