/*
 * Copyright 2024 Bloomberg Finance LP
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef INCLUDED_BUILDBOXCOMMON_LOGGING_COMMANDLINE
#define INCLUDED_BUILDBOXCOMMON_LOGGING_COMMANDLINE

#include <buildboxcommon_commandline.h>
#include <buildboxcommon_logging.h>
#include <vector>

namespace buildboxcommon {

/**
 * Return a command sline parser spec for parsing logging-related optinons
 */
std::vector<buildboxcommon::CommandLineTypes::ArgumentSpec>
loggingCommandLineSpec();

/**
 * Read logging-related options from parsed command line.
 */
bool parseLoggingOptions(const CommandLine &cml,
                         buildboxcommon::LogLevel &logLevel);

}; // namespace buildboxcommon

#endif
