# 0.2.0

**Version:** 0.2.0
**Published:** 2025-09-06T21:54:03Z

## Release Notes

### 📦 **Rust Coreutils 0.2.0 Release:**

We are excited to announce the release of **Rust Coreutils 0.2.0** — our **first fully internationalized release**!
This milestone brings **comprehensive localization support**, **major performance improvements**, and **enhanced Unicode handling**.

---

### Highlights:

- **Full Internationalization & Localization**
  Complete translation infrastructure using Mozilla's Fluent framework with French translations included.
  Support for complex plural forms (Arabic, Hebrew, etc.) and locale-aware formatting.
  Even error messages from clap are fully localizable!

- **Community Translation Platform**
  Join our translation efforts at [Weblate](https://hosted.weblate.org/projects/rust-coreutils/)
  or contribute directly via our [l10n repository](https://github.com/uutils/coreutils-l10n)

- **Unicode & Non-UTF8 Path Support**
  All programs now handle non-UTF8 paths seamlessly while supporting full Unicode features.
  Example: `echo "🍔🍟🥤" | cut -d"🍟" -f1` works perfectly with emoji delimiters!

- **Massive Performance Gains**
  Notable example: `tr` went from **9.81x slower** than GNU to **1.58x faster** — a 15x improvement!
  Additional optimizations in sort, cat, and other utilities.

- **Enhanced GNU Compatibility**
  **538 passing tests** (+16 from 0.1.0), with reduced failures from 65 to 52.
  Continued improvements in edge case handling and behavior matching.

- **Production Ready for Ubuntu**
  As part of Ubuntu's [announcement](https://lists.ubuntu.com/archives/ubuntu-devel/2025-September/043437.html) of plans to integrate Rust Coreutils, this release focuses on stability and compatibility improvements to ensure Ubuntu users have the best possible experience.

---

### GNU Test Suite Compatibility:

| Result        | 0.1.0 | 0.2.0 | Change 0.1.0 to 0.2.0 | % Total 0.1.0 | % Total 0.2.0 | % Change 0.1.0 to 0.2.0 |
|---------------|-------|-------|------------------------|---------------|---------------|--------------------------|
| Pass          | 522   | 538   | +16                    | 84.46%        | 87.06%        | +2.60%                   |
| Skip          | 31    | 27    | -4                     | 5.02%         | 4.37%         | -0.65%                   |
| Fail          | 65    | 52    | -13                    | 10.52%        | 8.42%         | -2.10%                   |
| Error         | 0     | 1     | +1                     | 0%            | 0.16%         | +0.16%                   |
| Total         | 618   | 618   | 0                      |               |               |                          |

---

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.svg?raw=true)

---

### Call to Action:

🌍 **Help us translate** - Contribute translations at [Weblate](https://hosted.weblate.org/projects/rust-coreutils/)
🚀 **Sponsor us on GitHub** to accelerate development: [github.com/sponsors/uutils](https://github.com/sponsors/uutils)
🔗 Download the latest release: [https://uutils.github.io](https://uutils.github.io)

## What's Changed

## basenc
* allow non-UTF8 filenames by @cakebaker in https://github.com/uutils/coreutils/pull/8558

## basename
* Simply logic, do not trim path separators `/` by @drinkcat in https://github.com/uutils/coreutils/pull/8372
* handle a corner case with /. - Closes #8373 by @sylvestre in https://github.com/uutils/coreutils/pull/8374
* Handle non-unicode parameters by @drinkcat in https://github.com/uutils/coreutils/pull/8375

## cat
* Fix reporting "input file is output file" error when outputting to an input file by @frendsick in https://github.com/uutils/coreutils/pull/8025
* add error handling in write_fast function by @yuankunzhang in https://github.com/uutils/coreutils/pull/8091
* handle broken pipe gracefully by @tgrez in https://github.com/uutils/coreutils/pull/8336

## chmod
* fix recursive symlink handling for -H/-L/-P flags (Closes: #8422) by @sylvestre in https://github.com/uutils/coreutils/pull/8450
* remove Windows function & unnecessary cfgs by @cakebaker in https://github.com/uutils/coreutils/pull/8458
* make a test environment-agnostic by @sylvestre in https://github.com/uutils/coreutils/pull/8525

## chown
* fix --reference file syntax by @Anonymous-AAA in https://github.com/uutils/coreutils/pull/8492

## chroot
* remove unwrap calls by @jovielarue in https://github.com/uutils/coreutils/pull/7890

## cksum
* remove duplicate unit test by @cakebaker in https://github.com/uutils/coreutils/pull/8151
* Fix file quoting on stderr by @RenjiSann in https://github.com/uutils/coreutils/pull/8272
* two small refactorings by @cakebaker in https://github.com/uutils/coreutils/pull/8527

## cp
* migrate from quick-error to thiserror by @vikram-kangotra in https://github.com/uutils/coreutils/pull/7989
* clean existing file when copy from stream by @Luv-Ray in https://github.com/uutils/coreutils/pull/8149
* let `clap` render help & version by @cakebaker in https://github.com/uutils/coreutils/pull/8199
* Fix --no-dereference --parents with symlink source by @julian-klode in https://github.com/uutils/coreutils/pull/8331
* Try to change gid only if changing uid+gid fails by @drinkcat in https://github.com/uutils/coreutils/pull/8385
* Properly preserves fifos and symlink attributes by @drinkcat in https://github.com/uutils/coreutils/pull/8416
* fix directory permission preservation for sibling directories with -a (Closes: #8407) by @sylvestre in https://github.com/uutils/coreutils/pull/8449
* fix recursive socket file copy by @Anonymous-AAA in https://github.com/uutils/coreutils/pull/8478

## csplit
* fix two issues with non ASCII digits by @cakebaker in https://github.com/uutils/coreutils/pull/8020

## date
* date/ls: Switch from chrono to jiff by @drinkcat in https://github.com/uutils/coreutils/pull/7894
* update deprecated TZ by @sylvestre in https://github.com/uutils/coreutils/pull/8405
* allow multiple `-d`, last wins by @cakebaker in https://github.com/uutils/coreutils/pull/8507
* add hidden aliases --rfc-2822/822 for GNU compat by @schopin-pro in https://github.com/uutils/coreutils/pull/8550

## df
* Move to using `OsString` by @drinkcat in https://github.com/uutils/coreutils/pull/8371

## du
* create the string into the main thread to avoid some translations issue by @sylvestre in https://github.com/uutils/coreutils/pull/8338
* du/ls: Merge date formatting code, and handle timestamps far in the future/past by just printing them by @drinkcat in https://github.com/uutils/coreutils/pull/8390
* `du`/`ls`: Unify file metadata time handling by @drinkcat in https://github.com/uutils/coreutils/pull/8396
* `du`/`ls`: Improve time-style handling based on GNU coreutils manual by @drinkcat in https://github.com/uutils/coreutils/pull/8415

## echo
* fixed double hyphen as argument by @cerdelen in https://github.com/uutils/coreutils/pull/7581
* Remove clap for echo by @cerdelen in https://github.com/uutils/coreutils/pull/7603
* print help if not posixly correct and only argument is --help by @RGBCube in https://github.com/uutils/coreutils/pull/8310
* show version when `--version` is the only argument by @cakebaker in https://github.com/uutils/coreutils/pull/8341

## env
* use execvp instead of Command::status on Unix systems by @yuankunzhang in https://github.com/uutils/coreutils/pull/8365
* invalid syntx with the french fluent file by @sylvestre in https://github.com/uutils/coreutils/pull/8530

## expr
* Handle more special cases for regex pattern by @frendsick in https://github.com/uutils/coreutils/pull/7974
* Fix parsing range quantifiers in regex by @frendsick in https://github.com/uutils/coreutils/pull/7997
* Fix handling of regex range quantifiers by @frendsick in https://github.com/uutils/coreutils/pull/8010
* Remove `expr.pl` from `why-error.md` by @frendsick in https://github.com/uutils/coreutils/pull/8022
* fix substr parsing by @tgrez in https://github.com/uutils/coreutils/pull/8158
* fix builtin functions precedence by @tgrez in https://github.com/uutils/coreutils/pull/8162

## factor
* fix two "unused import" warnings in test by @cakebaker in https://github.com/uutils/coreutils/pull/8526

## fmt
* Fix the last two GNU tests for fmt by @sylvestre in https://github.com/uutils/coreutils/pull/8264

## fold
* process streams as bytes, not strings, to handle non-utf8 data by @phinjensen in https://github.com/uutils/coreutils/pull/8241

## hashsum
* don't exit early on io errors by @Qelxiros in https://github.com/uutils/coreutils/pull/7918

## head
* fix bug with non-terminated files. by @karlmcdowall in https://github.com/uutils/coreutils/pull/7484
* fix meaning of ---presume-input-pipe by @bvinc in https://github.com/uutils/coreutils/pull/8315
* remove `BadEncoding` variant of `HeadError` by @cakebaker in https://github.com/uutils/coreutils/pull/8484
* refactor `uumain` by @cakebaker in https://github.com/uutils/coreutils/pull/8497

## install
* don't error when multiple arguments of the same type are given, instead override with last one (#8033) by @jenningsfan in https://github.com/uutils/coreutils/pull/8053
* implement option -C by @sylvestre in https://github.com/uutils/coreutils/pull/8265
* use `bool` as return type of `need_copy` by @cakebaker in https://github.com/uutils/coreutils/pull/8288
* Fix --no-target-directory with existing file by @julian-klode in https://github.com/uutils/coreutils/pull/8412
* install, mkdir: Handle dir/./ like dir/. by @julian-klode in https://github.com/uutils/coreutils/pull/8366

## ln
* fix #6350 by @RenjiSann in https://github.com/uutils/coreutils/pull/7449
* rename error variant by @cakebaker in https://github.com/uutils/coreutils/pull/8035

## logname
* remove `unsafe extern "C"` block by @cakebaker in https://github.com/uutils/coreutils/pull/8177

## ls
* move recent time threshold comment by @deadmeu in https://github.com/uutils/coreutils/pull/8214
* follow symlinks for xattrs, fix #8216 by @sudhackar in https://github.com/uutils/coreutils/pull/8217
* fix the GNU test tests/ls/selinux.sh by @sylvestre in https://github.com/uutils/coreutils/pull/8281
* improve the test when running selinux by @sylvestre in https://github.com/uutils/coreutils/pull/8403
* -u/-c/--time control sorting when -l is not used by @drinkcat in https://github.com/uutils/coreutils/pull/8417

## mkdir
* Fix mkdir with non-unicode parameters by @drinkcat in https://github.com/uutils/coreutils/pull/8367
* Replaced strict restorecon compatibility check with validation… by @sylvestre in https://github.com/uutils/coreutils/pull/8340
* refactor(mkdir): Simplify mode argument parsing by @amirhosseinghanipour in https://github.com/uutils/coreutils/pull/8406

## mkfifo
* support symbolic mode by @yuankunzhang in https://github.com/uutils/coreutils/pull/8440

## mknod
* set cli specified file mode even when it's 0o666 by @TheJJ in https://github.com/uutils/coreutils/pull/8343

## mktemp
* allow empty string arguments for -p/--tmpdir options by @yuankunzhang in https://github.com/uutils/coreutils/pull/8447

## more
* tests: cleanup processes in test_valid_arg by @martinkunkel2 in https://github.com/uutils/coreutils/pull/8430

## mv
*  moving dangling symlinks into directories  by @albus-droid in https://github.com/uutils/coreutils/pull/8064
* improve the hardlink support by @sylvestre in https://github.com/uutils/coreutils/pull/8296
* add support for selinux and add minor refactor  by @sylvestre in https://github.com/uutils/coreutils/pull/8333
* use `next()` instead of `peekable().peek()` in `is_empty_dir()` by @cakebaker in https://github.com/uutils/coreutils/pull/8413
* move a string in fluent by @sylvestre in https://github.com/uutils/coreutils/pull/8434
* treat symlinks as files by @id3v1669 in https://github.com/uutils/coreutils/pull/8528

## nice
* remove useless translations by @sylvestre in https://github.com/uutils/coreutils/pull/8295

## nl
* use `OsString` for `--number-separator` by @cakebaker in https://github.com/uutils/coreutils/pull/8519
* allow zero for `--join-blank-lines` by @cakebaker in https://github.com/uutils/coreutils/pull/8540
* support files with non-utf8 content by @cakebaker in https://github.com/uutils/coreutils/pull/8544

## od
* fix handling of non-ascii chars by @tgrez in https://github.com/uutils/coreutils/pull/8268
* fix typo in help by @cakebaker in https://github.com/uutils/coreutils/pull/8344
* Fixes float formatting in scientific notation by @yonatan-linik in https://github.com/uutils/coreutils/pull/8352
* Add support for -tfH and -tfB by @karanabe in https://github.com/uutils/coreutils/pull/8354
* rename `flo16`/`flo32`/`flo64` to `f16`/`f32`/`f64` in function names by @cakebaker in https://github.com/uutils/coreutils/pull/8369
* use underscores in filenames, adapt modules by @cakebaker in https://github.com/uutils/coreutils/pull/8393
* Switch f16 print to width=15/16, precision=8 by @drinkcat in https://github.com/uutils/coreutils/pull/8433

## pr
* Add support for -D/--date-format parameter by @drinkcat in https://github.com/uutils/coreutils/pull/8418
* reduce nesting to improve readability of `file_last_modified_time_format()` by @cakebaker in https://github.com/uutils/coreutils/pull/8420

## printf
* Fix formatting hexadecimals with padding by @frendsick in https://github.com/uutils/coreutils/pull/8185
* accept non-UTF-8 input in FORMAT and ARGUMENT arguments by @drinkcat in https://github.com/uutils/coreutils/pull/8329

## pwd
* style(pwd): simplify physical_path implementation by @amirhosseinghanipour in https://github.com/uutils/coreutils/pull/8409

## realpath
* use consts for all options by @cakebaker in https://github.com/uutils/coreutils/pull/8150

## rm
* add support for the `--interactive` arg aliases by @cakebaker in https://github.com/uutils/coreutils/pull/8419
* do "early return" earlier in `uumain` by @cakebaker in https://github.com/uutils/coreutils/pull/8045
* rename two consts for better readability by @cakebaker in https://github.com/uutils/coreutils/pull/8070
* consistent naming of test functions by @cakebaker in https://github.com/uutils/coreutils/pull/8084
* fix too long filename corner case by @tgrez in https://github.com/uutils/coreutils/pull/8299
* improve `is_dir_empty` from O(n) to O(1) by @cakebaker in https://github.com/uutils/coreutils/pull/8384
* remove duplicate test by @cakebaker in https://github.com/uutils/coreutils/pull/8494
* fix unused var warning on non-(unix & windows) by @cakebaker in https://github.com/uutils/coreutils/pull/8495

## shred
* implement and test feature --random-source by @BenWiederhake in https://github.com/uutils/coreutils/pull/7948

## sort
* prevent -o/--output to be specified multiple times by @RenjiSann in https://github.com/uutils/coreutils/pull/7991
* Fix sort-files0-from.log by @Charlie-Zheng in https://github.com/uutils/coreutils/pull/8011
* Make use of ExtendedBigDecimal in -g sorting, then attempt to recover some performance by @drinkcat in https://github.com/uutils/coreutils/pull/8062
* Support hexadecimal numbers/floats correctly by @yonatan-linik in https://github.com/uutils/coreutils/pull/8377
* Handle non-utf8 sorting content by @RenjiSann in https://github.com/uutils/coreutils/pull/8386
* adjust the behavior of 'sort --output --file-with-dash' to match GNU's by @sylvestre in https://github.com/uutils/coreutils/pull/8482

## stat
* stat/locales: Fix fluent_linter errors by @drinkcat in https://github.com/uutils/coreutils/pull/8404
* `stat`: Convert to use `uucore` functions by @drinkcat in https://github.com/uutils/coreutils/pull/8398

## stdbuf
* fix cross-compilation by @Ecordonnier in https://github.com/uutils/coreutils/pull/7972
* avoid double "lib" prefix by @Ecordonnier in https://github.com/uutils/coreutils/pull/8067
* add feat_external_libstdbuf by @Ecordonnier in https://github.com/uutils/coreutils/pull/8104
* GNUMakefile: install libstdbuf by @Ecordonnier in https://github.com/uutils/coreutils/pull/8238

## stty
* Add stty to GNUmakefile by @oech3 in https://github.com/uutils/coreutils/pull/8013
* fix output redirection by @willshuttleworth in https://github.com/uutils/coreutils/pull/8016
* set control characters by @willshuttleworth in https://github.com/uutils/coreutils/pull/7931
* fix negated options getting rejected by clap by @willshuttleworth in https://github.com/uutils/coreutils/pull/8136
* fix mappings with empty string literal args by @willshuttleworth in https://github.com/uutils/coreutils/pull/8135
* add ispeed/ospeed settings by @willshuttleworth in https://github.com/uutils/coreutils/pull/8180
* add options to set and print terminal size by @willshuttleworth in https://github.com/uutils/coreutils/pull/8221
* remove redundant `cfg` by @cakebaker in https://github.com/uutils/coreutils/pull/8262
* `stty`: remove quotes around strings in locale files by @willshuttleworth in https://github.com/uutils/coreutils/pull/8290
* `stty`: special settings by @willshuttleworth in https://github.com/uutils/coreutils/pull/8309
* add combination settings by @willshuttleworth in https://github.com/uutils/coreutils/pull/8256
* print non-default control characters by @yuankunzhang in https://github.com/uutils/coreutils/pull/8280
* refactor arg processing loop by @willshuttleworth in https://github.com/uutils/coreutils/pull/8359

## sync
* adjust safety comments by @jtracey in https://github.com/uutils/coreutils/pull/8024
* reduce use of unsafe and improve comments by @jtracey in https://github.com/uutils/coreutils/pull/8017

## tail
* fix test that disables output in bash shell by @willshuttleworth in https://github.com/uutils/coreutils/pull/8157
* fix tailing /dev/zero by @bvinc in https://github.com/uutils/coreutils/pull/8314
* handle broken pipe gracefully by @tgrez in https://github.com/uutils/coreutils/pull/8327
* show end of device by @martinkunkel2 in https://github.com/uutils/coreutils/pull/8037

## tee
* tests/tee: enable no_more_writable test by @Maximkaaa in https://github.com/uutils/coreutils/pull/8219
* remove output buffering by @Maximkaaa in https://github.com/uutils/coreutils/pull/8218
* move test to `linux_only` module by @cakebaker in https://github.com/uutils/coreutils/pull/8225

## timeout
* catch TERM signal by @Luv-Ray in https://github.com/uutils/coreutils/pull/8197

## touch
* fix f flag by @VenetiaFurtado in https://github.com/uutils/coreutils/pull/8274
* Bump `parse_datetime` & adapt `touch` tests by @cakebaker in https://github.com/uutils/coreutils/pull/8424

## tr
* some small improvements by @cakebaker in https://github.com/uutils/coreutils/pull/8126
* handle broken pipe gracefully by @yuankunzhang in https://github.com/uutils/coreutils/pull/8298
* restore default action of sigpipe by @yuankunzhang in https://github.com/uutils/coreutils/pull/8312
* Fix regression causing read error with sockets by @JohnoKing in https://github.com/uutils/coreutils/pull/8083
* fix high memory use, possible heap exhaustion by @julian-klode in https://github.com/uutils/coreutils/pull/8435
* Improve tr performances (Closes: #8439)  by @sylvestre in https://github.com/uutils/coreutils/pull/8442
* refactor and introduce simd to get important perf win  by @sylvestre in https://github.com/uutils/coreutils/pull/8471

## uname
* output OS last by @cakebaker in https://github.com/uutils/coreutils/pull/8094

## unexpand
* add -f short alias for --first-only by @GTimothy in https://github.com/uutils/coreutils/pull/8229

## uptime
* use "0 users" instead of "0 user" by @cakebaker in https://github.com/uutils/coreutils/pull/8069
* move imports into test function by @cakebaker in https://github.com/uutils/coreutils/pull/8052
* improve readability of `uptime_since` by @cakebaker in https://github.com/uutils/coreutils/pull/8164

## users
* fix unused imports in tests on FreeBSD by @cakebaker in https://github.com/uutils/coreutils/pull/8488

## who
* honor locale settings by @yuankunzhang in https://github.com/uutils/coreutils/pull/8535
* use `match` instead of `if`/`else` chain by @cakebaker in https://github.com/uutils/coreutils/pull/8541
* rename var, cleanup spell-checker:ignore by @cakebaker in https://github.com/uutils/coreutils/pull/8411

## uucore
* num_parser: Update pow_with_context by @drinkcat in https://github.com/uutils/coreutils/pull/8028
* locale: Use if let instead of match by @drinkcat in https://github.com/uutils/coreutils/pull/8050
* use authors.workspace by @sylvestre in https://github.com/uutils/coreutils/pull/8057
* fix clippy warnings - the following explicit lifetimes could be elided: 'a by @sylvestre in https://github.com/uutils/coreutils/pull/8269
* uucore(quoting_style): Improve quoting style handling by @RenjiSann in https://github.com/uutils/coreutils/pull/8271
* lib/mods/locale: fix locale loading by @kevinburke in https://github.com/uutils/coreutils/pull/8234
* uucore/fs: call `to_string_lossy` only once in `dir_strip_dot_for_creation` by @cakebaker in https://github.com/uutils/coreutils/pull/8399
* locale: Fix clippy warning by @drinkcat in https://github.com/uutils/coreutils/pull/8432
* num_format: Optimize `format_float_shortest` by @drinkcat in https://github.com/uutils/coreutils/pull/8444
* uucore/clap_localization: use iterator from `lines()` by @cakebaker in https://github.com/uutils/coreutils/pull/8536
* uucore/locale: move duplicate code to closure by @cakebaker in https://github.com/uutils/coreutils/pull/8549

## Localization & Internationalization
* Improve the locale support by @sylvestre in https://github.com/uutils/coreutils/pull/7981
* convert the md files to fluent by @sylvestre in https://github.com/uutils/coreutils/pull/8054
* Disable Unicode directional isolate characters (U+2068, U+2069) by @sylvestre in https://github.com/uutils/coreutils/pull/8066
* document a bit how it works by @sylvestre in https://github.com/uutils/coreutils/pull/8102
* i18n: Locale-aware quoting by @RenjiSann in https://github.com/uutils/coreutils/pull/8179
* i18n: further work, expr support by @RenjiSann in https://github.com/uutils/coreutils/pull/8292
* replace `\n` with a new line in ftl files by @cakebaker in https://github.com/uutils/coreutils/pull/8349
* Setup localization for utility symlinks by @julian-klode in https://github.com/uutils/coreutils/pull/8364
* Create macros for l10n translations by @sylvestre in https://github.com/uutils/coreutils/pull/8392
* embedded english strings + test the whole thing in github by @sylvestre in https://github.com/uutils/coreutils/pull/8423
* add support for clap translations by @sylvestre in https://github.com/uutils/coreutils/pull/8431
* clap localization improvements by @sylvestre in https://github.com/uutils/coreutils/pull/8520
* clap/locale: fix the colors for all programs (Closes: #8501) by @sylvestre in https://github.com/uutils/coreutils/pull/8542
* Allow non-utf8 paths name as input for most of the programs by @sylvestre in https://github.com/uutils/coreutils/pull/8457
* port base32 for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8287
* port basenc for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8167
* port basename to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8074
* add support for translation by @sylvestre in https://github.com/uutils/coreutils/pull/8529
* port chcon to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8086
* port chgrp for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8168
* port chmod for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8245
* port chown for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8260
* port chroot for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8170
* port cksum for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8148
* port comm for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8169
* port cp for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8200
* port csplit for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8147
* port cut for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8171
* port date for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8258
* port dd for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8191
* port df for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8239
* port dircolors for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8141
* port dirname to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8085
* port du for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8176
* port echo for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8247
* port env for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8204
* port expand for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8205
* port expr for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8118
* port factor for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8206
* port false to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8097
* port fmt for translation + use thiserror + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8242
* port fold to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8100
* port groups to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8098
* port hashsum for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8207
* port head for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8240
* port hostname to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8082
* port id to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8073
* port install for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8192
* port join for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8193
* port kill for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8139
* port link for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8140
* port ln for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8248
* port logname for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8172
* port ls for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8249
* port mkdir to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8089
* port mkfifo for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8182
* port mknod for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8183
* port mktemp for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8184
* port more for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8250
* port mv for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8251
* port nice to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8076
* port nl for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8181
* port nohup for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8173
* port nproc to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8077
* port numfmt for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8208
* port od for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8252
* port paste for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8142
* port pathchk for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8143
* port pinky for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8144
* port pr for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8253
* port printenv for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8209
* port printf for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8212
* port ptx for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8188
* port pwd for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8119
* port readlink for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8145
* port realpath for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8146
* port rm for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8259
* port rmdir for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8174
* port runcon for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8187
* port seq for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8195
* port shred for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8194
* port shuf for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8175
* port sleep to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8087
* port sort for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8244
* port split for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8211
* port stat for translation + use thiserror + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8243
* port stdbuf for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8254
* port stty for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8257
* port sum for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8120
* port sync to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8088
* port tac for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8125
* port tail for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8124
* port tee for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8122
* port test for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8121
* port timeout for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8117
* port touch for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8116
* port tr for translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8112
* port true to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8099
* port truncate to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8111
* port tsort to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8095
* port tty to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8110
* port uname to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8080
* port unexpand to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8109
* port uniq to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8108
* port unlink to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8107
* port uptime to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8092
* port users to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8106
* port wc to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8105
* port who to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8079
* port whoami to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8081
* port yes to translation + add french by @sylvestre in https://github.com/uutils/coreutils/pull/8078

## Test Improvements
* Fix macros, rewrite tests to use idiomatic macros by @RenjiSann in https://github.com/uutils/coreutils/pull/8293
* add tests with emoji for various commands by @sylvestre in https://github.com/uutils/coreutils/pull/8545
* add more emoji tests by @sylvestre in https://github.com/uutils/coreutils/pull/8551
* fix execution on WSL2, Ubuntu 24.04 by @martinkunkel2 in https://github.com/uutils/coreutils/pull/8235
* On MacOS, ignore tests that use /dev/fd/0 by @drinkcat in https://github.com/uutils/coreutils/pull/8454
* tests/cp/preserve-gid: Partial fix by @drinkcat in https://github.com/uutils/coreutils/pull/8380

## Code Quality & Cleanup
* cleanup workspace crates by @nyurik in https://github.com/uutils/coreutils/pull/8058
* Enable common pre-commit.ci fixes by @nyurik in https://github.com/uutils/coreutils/pull/8059
* Prepare for clippy pedantic rules by @gabelluardo in https://github.com/uutils/coreutils/pull/8201
* Enable some pedantic rules by @gabelluardo in https://github.com/uutils/coreutils/pull/8203
* a lot of documentation cleanups by @nyurik in https://github.com/uutils/coreutils/pull/8301
* remove unused dependencies by @nyurik in https://github.com/uutils/coreutils/pull/8056
* cleanup `inefficient_to_string` lint by @nyurik in https://github.com/uutils/coreutils/pull/8303
* cleanup `map_unwrap_or` lint by @nyurik in https://github.com/uutils/coreutils/pull/8302
* fix more inefficient_to_string by @RenjiSann in https://github.com/uutils/coreutils/pull/8316
* minor Cargo.toml linting by @nyurik in https://github.com/uutils/coreutils/pull/8319
* convert comments to markdown docs by @nyurik in https://github.com/uutils/coreutils/pull/8304
* fix unnecessary_semicolon lint by @nyurik in https://github.com/uutils/coreutils/pull/8321
* fix uninlined_format_args lint by @nyurik in https://github.com/uutils/coreutils/pull/8320
* fix expl_impl_clone_on_copy lint by @nyurik in https://github.com/uutils/coreutils/pull/8328
* fix warnings from `uninlined_format_args` lint by @cakebaker in https://github.com/uutils/coreutils/pull/8279
* replace vector indexing with safe .get() method by @sylvestre in https://github.com/uutils/coreutils/pull/8282
* fix clippy by @Luv-Ray in https://github.com/uutils/coreutils/pull/8275
* Cargo.toml: remove `match_on_vec_items` lint by @cakebaker in https://github.com/uutils/coreutils/pull/8277
* fix warnings introduced with Rust `1.89` by @cakebaker in https://github.com/uutils/coreutils/pull/8446

## CI & Build
* publish.sh: also publish uutests by @sylvestre in https://github.com/uutils/coreutils/pull/7984
* Reenable windows-latest/x86_64-pc-windows-gnu (and do not update gcc) by @drinkcat in https://github.com/uutils/coreutils/pull/7985
* publish.sh: be more prescriptive on the grep by @sylvestre in https://github.com/uutils/coreutils/pull/7983
* reduce timeout of freebsd jobs by @cakebaker in https://github.com/uutils/coreutils/pull/7994
* .pre-commit-config.yaml: Do not fail cspell if all files are ignored by @drinkcat in https://github.com/uutils/coreutils/pull/8026
* clippy pre-commit/CI improvements by @drinkcat in https://github.com/uutils/coreutils/pull/8030
* GNU CI: also build selinux with --release-build by @sylvestre in https://github.com/uutils/coreutils/pull/8055
* GNUMakefile: fix compilation on Macs by @kevinburke in https://github.com/uutils/coreutils/pull/7964
* adapt `ARTIFACTS_SUFFIX` if "features" not set by @cakebaker in https://github.com/uutils/coreutils/pull/8113
* add missing braces by @cakebaker in https://github.com/uutils/coreutils/pull/8114
* Make cspell pre-commit hook optional with skip message by @sylvestre in https://github.com/uutils/coreutils/pull/8138
* add the fluent hook conf file by @sylvestre in https://github.com/uutils/coreutils/pull/8237
* Use mozilla fluent linter (and remove mine) by @sylvestre in https://github.com/uutils/coreutils/pull/8284
* remove unneeded file by @RenjiSann in https://github.com/uutils/coreutils/pull/8266
* fix ftl - Identifiers may only contain lowercase characters and - by @sylvestre in https://github.com/uutils/coreutils/pull/8283
* util/build-gnu.sh: Bypass timeout/yes SIGPIPE handling bug by @drinkcat in https://github.com/uutils/coreutils/pull/8353
* .github/workflows/CICD.yml: Speed up Build/SELinux by @drinkcat in https://github.com/uutils/coreutils/pull/8389
* Makefile: Copy locales _after_ build by @drinkcat in https://github.com/uutils/coreutils/pull/8379
* CI: GnuTests: Split native and selinux tests to 2 different jobs by @drinkcat in https://github.com/uutils/coreutils/pull/8388
* Fix get_context on fifos (and symlinks) by @drinkcat in https://github.com/uutils/coreutils/pull/8401
* github action: moz-fluent-l10n runs a directory, not a file by @sylvestre in https://github.com/uutils/coreutils/pull/8533
* Do not build SELinux programs on FreeBSD when using make by @martinkunkel2 in https://github.com/uutils/coreutils/pull/8443
* .github/workflows/CICD.yml: Create a fully fake utmp by @drinkcat in https://github.com/uutils/coreutils/pull/8456
* use `macos-latest` instead of `macos-13` by @cakebaker in https://github.com/uutils/coreutils/pull/8334
* Add devcontainer setup and small related fixes by @martinkunkel2 in https://github.com/uutils/coreutils/pull/8486
* add support for systemd-logind by @Ecordonnier in https://github.com/uutils/coreutils/pull/8483
* prepare the publication of uufuzz + add emojis by @sylvestre in https://github.com/uutils/coreutils/pull/8563
* prepare release 0.2.0 by @sylvestre in https://github.com/uutils/coreutils/pull/8561

## Documentation
* extensions: Explain how printf/seq handle precision by @drinkcat in https://github.com/uutils/coreutils/pull/7641
* add `-U`/`--no-utf8` as extension of `expand`/`unexpand` by @cakebaker in https://github.com/uutils/coreutils/pull/8236
* Improvements of the docs by @sylvestre in https://github.com/uutils/coreutils/pull/8543

## Platform Support
* flake.nix: Add cspell by @RenjiSann in https://github.com/uutils/coreutils/pull/7987
* silence musl warnings by @Ecordonnier in https://github.com/uutils/coreutils/pull/8018
* Feat/add wezterm to terms by @eldyl in https://github.com/uutils/coreutils/pull/8047
* add `--version` argument to print main binary version by @MarcusGrass in https://github.com/uutils/coreutils/pull/8127
* remove PROJECT_NAME_FOR_VERSION_STRING by @Ecordonnier in https://github.com/uutils/coreutils/pull/8360

## Dependency Updates
* Bump `onig` from `6.4.0` to `6.5.1` by @cakebaker in https://github.com/uutils/coreutils/pull/7976
* Cargo.lock: Bump toml_edit to latest version by @drinkcat in https://github.com/uutils/coreutils/pull/7988
* Bump `type-map` by @cakebaker in https://github.com/uutils/coreutils/pull/7993
* Cargo.toml: remove unused `coz` dependency by @cakebaker in https://github.com/uutils/coreutils/pull/8021
* deny.toml: remove obsolete skips related to rustix by @alerque in https://github.com/uutils/coreutils/pull/8019
* Cargo.toml: remove `procfs` dependency & adapt `cp` test by @cakebaker in https://github.com/uutils/coreutils/pull/8027
* Bump `windows-sys` & adapt to API change by @cakebaker in https://github.com/uutils/coreutils/pull/8160
* Bump selinux crates by @cakebaker in https://github.com/uutils/coreutils/pull/8226
* Bump `phf` and `phf_codegen` & fix compilation errors by @cakebaker in https://github.com/uutils/coreutils/pull/8233
* Bump `linux-raw-sys` by @cakebaker in https://github.com/uutils/coreutils/pull/8289
* deny.toml: remove old `windows-sys` version from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/8438
* Bump `parse_datetime` & adapt `touch` tests by @cakebaker in https://github.com/uutils/coreutils/pull/8424
* Cargo.toml: lock version of `selinux` by @cakebaker in https://github.com/uutils/coreutils/pull/8502
* Bump `phf` & `phf_codegen` from `0.12.1` to `0.13.1` by @cakebaker in https://github.com/uutils/coreutils/pull/8516
* Bump `windows-sys` from `0.60.1` to `0.61.0` by @cakebaker in https://github.com/uutils/coreutils/pull/8557
* chore(deps): update rust crate clap to v4.5.39 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8014
* chore(deps): update rust crate clap_complete to v4.5.51 - autoclosed by @renovate[bot] in https://github.com/uutils/coreutils/pull/8015
* chore(deps): update dawidd6/action-download-artifact action to v10 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8041
* chore(deps): update rust crate clap_complete to v4.5.52 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8038
* chore(deps): update rust crate jiff to v0.2.14 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8042
* fix(deps): update rust crate libc to v0.2.173 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8166
* chore(deps): update rust crate bytecount to v0.6.9 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8051
* chore(deps): update rust crate clap_complete to v4.5.53 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8130
* chore(deps): update rust crate clap to v4.5.40 - autoclosed by @renovate[bot] in https://github.com/uutils/coreutils/pull/8129
* chore(deps): update rust crate clap_complete to v4.5.54 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8132
* chore(deps): update rust crate clap_mangen to v0.2.27 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8133
* chore(deps): update rust crate unicode-width to v0.2.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8137
* chore(deps): update rust crate memchr to v2.7.5 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8154
* chore(deps): update rust crate windows-sys to v0.60.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8163
* chore(deps): update rust crate jiff to v0.2.15 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8165
* chore(deps): update dawidd6/action-download-artifact action to v11 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8186
* chore(deps): update rust crate zip to v4.1.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8189
* chore(deps): update vmactions/freebsd-vm action to v1.2.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8190
* fix(deps): update rust crate libc to v0.2.174 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8210
* chore(deps): update rust crate zip to v4.2.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8255
* chore(deps): update rust crate xattr to v1.5.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8267
* fix(deps): update rust crate console to 0.16.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8278
* chore(deps): update rust crate indicatif to v0.17.12 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8291
* chore(deps): update rust crate rust-ini to v0.21.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8300
* chore(deps): update rust crate notify to v8.1.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8306
* fix(deps): update rust crate libfuzzer-sys to v0.4.10 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8311
* chore(deps): update rust crate indicatif to 0.18.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8313
* chore(deps): update rust crate clap to v4.5.41 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8324
* chore(deps): update rust crate clap_complete to v4.5.55 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8325
* chore(deps): update rust crate zip to v4.3.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8323
* chore(deps): update rust crate clap_mangen to v0.2.28 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8326
* chore(deps): update rust crate memmap2 to v0.9.7 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8337
* chore(deps): update rust crate crc32fast to v1.5.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8339
* fix(deps): update rust crate rand to v0.9.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8358
* chore(deps): update rust crate rstest to 0.26.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8394
* chore(deps): update rust crate rstest to v0.26.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8397
* chore(deps): update rust crate ctor to v0.4.3 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8400
* chore(deps): update rust crate clap_mangen to v0.2.29 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8410
* chore(deps): update rust crate clap to v4.5.42 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8414
* chore(deps): update rust crate notify to v8.2.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8428
* chore(deps): update actions/download-artifact action to v5 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8437
* chore(deps): update rust crate dns-lookup to v2.1.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8436
* chore(deps): update rust crate clap to v4.5.43 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8441
* chore(deps): update rust crate clap_complete to v4.5.56 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8451
* fix(deps): update rust crate proc-macro2 to v1.0.96 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8460
* chore(deps): update rust crate ctor to 0.5.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8461
* fix(deps): update rust crate libc to v0.2.175 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8464
* chore(deps): update rust crate glob to v0.3.3 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8465
* chore(deps): update actions/checkout action to v5 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8466
* fix(deps): update rust crate proc-macro2 to v1.0.97 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8473
* chore(deps): update rust crate terminal_size to v0.4.3 - autoclosed by @renovate[bot] in https://github.com/uutils/coreutils/pull/8468
* chore(deps): update rust crate clap to v4.5.44 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8469
* chore(deps): update rust crate clap_complete to v4.5.57 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8470
* chore(deps): update rust crate thiserror to v2.0.14 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8472
* chore(deps): update rust crate clap to v4.5.45 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8476
* chore(deps): update rust crate rayon to v1.11.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8477
* chore(deps): update actions/checkout action to v5 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8479
* chore(deps): update vmactions/freebsd-vm action to v1.2.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8487
* fix(deps): update rust crate proc-macro2 to v1.0.98 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8489
* chore(deps): update rust crate thiserror to v2.0.15 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8490
* fix(deps): update rust crate proc-macro2 to v1.0.101 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8491
* chore(deps): update vmactions/freebsd-vm action to v1.2.3 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8493
* chore(deps): update rust crate winapi-util to v0.1.10 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8498
* chore(deps): update rust crate thiserror to v2.0.16 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8500
* fix(deps): update rust crate tempfile to v3.21.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8499
* chore(deps): update rust crate filetime to v0.2.26 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8503
* chore(deps): update rust crate zip to v4.4.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8505
* chore(deps): update rust crate zip to v4.5.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8506
* chore(deps): update rust crate dns-lookup to v3 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8512
* chore(deps): update rust crate memmap2 to v0.9.8 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8510
* chore(deps): update mfinelli/setup-shfmt action to v4 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8511
* chore(deps): update rust crate regex to v1.11.2 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8518
* chore(deps): update rust crate clap to v4.5.46 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8524
* chore(deps): update rust crate rust-ini to v0.21.3 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8531
* chore(deps): update rust crate zip to v4.6.0 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8532
* chore(deps): update rust crate time to v0.3.42 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8539
* chore(deps): update rust crate clap to v4.5.47 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8546
* chore(deps): update rust crate time to v0.3.43 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8547
* chore(deps): update rust crate zip to v4.6.1 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8548
* chore(deps): update actions/setup-python action to v6 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8552
* chore(deps): update actions/github-script action to v8 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8554
* chore(deps): update rust crate zip to v5 by @renovate[bot] in https://github.com/uutils/coreutils/pull/8562

## New Contributors
* @oech3 made their first contribution in https://github.com/uutils/coreutils/pull/8013
* @alerque made their first contribution in https://github.com/uutils/coreutils/pull/8019
* @willshuttleworth made their first contribution in https://github.com/uutils/coreutils/pull/8016
* @Charlie-Zheng made their first contribution in https://github.com/uutils/coreutils/pull/8011
* @eldyl made their first contribution in https://github.com/uutils/coreutils/pull/8047
* @vikram-kangotra made their first contribution in https://github.com/uutils/coreutils/pull/7989
* @albus-droid made their first contribution in https://github.com/uutils/coreutils/pull/8064
* @tgrez made their first contribution in https://github.com/uutils/coreutils/pull/8158
* @MarcusGrass made their first contribution in https://github.com/uutils/coreutils/pull/8127
* @gabelluardo made their first contribution in https://github.com/uutils/coreutils/pull/8201
* @deadmeu made their first contribution in https://github.com/uutils/coreutils/pull/8214
* @Maximkaaa made their first contribution in https://github.com/uutils/coreutils/pull/8219
* @phinjensen made their first contribution in https://github.com/uutils/coreutils/pull/8241
* @jenningsfan made their first contribution in https://github.com/uutils/coreutils/pull/8053
* @VenetiaFurtado made their first contribution in https://github.com/uutils/coreutils/pull/8274
* @bvinc made their first contribution in https://github.com/uutils/coreutils/pull/8314
* @JohnoKing made their first contribution in https://github.com/uutils/coreutils/pull/8083
* @julian-klode made their first contribution in https://github.com/uutils/coreutils/pull/8331
* @RGBCube made their first contribution in https://github.com/uutils/coreutils/pull/8310
* @martinkunkel2 made their first contribution in https://github.com/uutils/coreutils/pull/8037
* @yonatan-linik made their first contribution in https://github.com/uutils/coreutils/pull/8352
* @karanabe made their first contribution in https://github.com/uutils/coreutils/pull/8354
* @amirhosseinghanipour made their first contribution in https://github.com/uutils/coreutils/pull/8409
* @TheJJ made their first contribution in https://github.com/uutils/coreutils/pull/8343
* @Anonymous-AAA made their first contribution in https://github.com/uutils/coreutils/pull/8478
* @id3v1669 made their first contribution in https://github.com/uutils/coreutils/pull/8528
* @schopin-pro made their first contribution in https://github.com/uutils/coreutils/pull/8550

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.1.0...0.2.0
