# 0.0.26

**Version:** 0.0.26
**Published:** 2024-04-26T21:47:48Z

## Release Notes

📦 **Rust Coreutils 0.0.26 Release:**

We are happy to announce the release of Rust Coreutils 0.0.26! This version comes with several significant advancements, including the initial support for AIX, ensuring broader compatibility and reach. Despite the short period since our last release, we've managed to fix numerous compatibility issues, further aligning our tools with the latest GNU testsuite, now version 9.5.

This update adds +10 GNU passing tests compared to version 0.0.25.

### New in this Release:
- **Beginning of the AIX Support**
- **Updated GNU Reference:** We've updated our testsuite to GNU Coreutils 9.5.
- **Improved Compatibility:** Thanks to the community's efforts, we've addressed several compatibility issues, pushing our pass rate even higher.
- **Automated Builds:** Binaries for the latest release are once again automatically generated.

This release saw contributions from 20 developers, including 12 newcomers.

We encourage you to support our project by sponsoring us on GitHub. Your sponsorship helps us maintain and enhance our infrastructure, such as GitHub Actions. Sponsor us at [https://github.com/sponsors/uutils](https://github.com/sponsors/uutils).

For more details and to download the latest release, visit our website at [https://uutils.github.io](https://uutils.github.io).

## GNU Test Suite Compatibility
Here’s how version 0.0.26 fares in comparison to the previous release:

| Result        | 0.0.25 | 0.0.26 | Change 0.0.25 to 0.0.26 | % Total 0.0.25 | % Total 0.0.26 | % Change 0.0.25 to 0.0.26 |
|---------------|--------|--------|-------------------------|----------------|----------------|--------------------------|
| Pass          | 437    | 447    | +10                     | 72.35%         | 73.04%         | +0.69%                   |
| Skip          | 50     | 44     | -6                      | 8.28%          | 7.19%          | -1.09%                   |
| Fail          | 117    | 121    | +4                      | 19.37%         | 19.77%         | +0.40%                   |
| Error         | 0      | 0      | 0                       | 0.00%          | 0.00%          | 0.00%                    |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

For more details, visit [https://github.com/uutils/coreutils-tracking/](https://github.com/uutils/coreutils-tracking/).


**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.25...0.0.26


## What's Changed

### cksum
* Adding -b as the short form of --base64 by @jadijadi in https://github.com/uutils/coreutils/pull/6187
* Fix code formatting by @cakebaker in https://github.com/uutils/coreutils/pull/6192

### comm
* Handle duplicated flags and output-delimiter correctly by @BenWiederhake in https://github.com/uutils/coreutils/pull/6112

### cp
* remove unnecessary calls of `touch()` in tests by @cakebaker in https://github.com/uutils/coreutils/pull/6263
* gnu "same-file" test case compatibility by @matrixhead in https://github.com/uutils/coreutils/pull/6190
* handle update prompt with and without interactive mode enabled by @BenWiederhake in https://github.com/uutils/coreutils/pull/6207
* Swap `cp`’s short `-r` and alias `-R` recursive options by @LucasLarson in https://github.com/uutils/coreutils/pull/6231
* Fix the debug results in `cp --debug` by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/6220

### csplit
* Handle repeated args, fix remainder after error by @BenWiederhake in https://github.com/uutils/coreutils/pull/6114

### cut
* Two new tests; -d conflict & no arg by @jadijadi in https://github.com/uutils/coreutils/pull/6191

### date
* Fix `date -f dates.txt is failing` by @mvo5 in https://github.com/uutils/coreutils/pull/6148
* Support `-f -` to read from stdin by @mvo5 in https://github.com/uutils/coreutils/pull/6160
* Remove unimplemented example by @LucasLarson in https://github.com/uutils/coreutils/pull/6135

### dd
* Handle SIGUSR1 directly. not just every 1sec by @cre4ture in https://github.com/uutils/coreutils/pull/6025
* Fix flaky test_null_stats by @BenWiederhake in https://github.com/uutils/coreutils/pull/6204

### dirname
* Accept repeated flag by @BenWiederhake in https://github.com/uutils/coreutils/pull/6151

### dircolors
* Accept repeated flags by @BenWiederhake in https://github.com/uutils/coreutils/pull/6150

### du
* Give `-h` output the same precision as GNU coreutils by @mvo5 in https://github.com/uutils/coreutils/pull/6226

### env
* argv0 overwrite possibility (unix only) - fixes new gnu test version by @cre4ture in https://github.com/uutils/coreutils/pull/6154
* Remove dependency on GNU env in tests by @cakebaker in https://github.com/uutils/coreutils/pull/6259
* Add missing space to help output by @cakebaker in https://github.com/uutils/coreutils/pull/6260

### hashsum
* Implement the ignore-missing option by @sylvestre in https://github.com/uutils/coreutils/pull/6230
* Improve the error management to match GNU by @sylvestre in https://github.com/uutils/coreutils/pull/6252

### head
* Two new tests. Improves function coverage from 38 to 75 by @jadijadi in https://github.com/uutils/coreutils/pull/6195

### kill
* Support multiple signals for --list by @m-haisham in https://github.com/uutils/coreutils/pull/6210
* Don't show `EXIT` with `--list` by @cakebaker in https://github.com/uutils/coreutils/pull/6222
* Return 1 and gnu style stderr in case of no pid by @jadijadi in https://github.com/uutils/coreutils/pull/6225
* Print --table as vertical by @m-haisham in https://github.com/uutils/coreutils/pull/6216
* Accept all cases for signal names by @m-haisham in https://github.com/uutils/coreutils/pull/6229
* Print signals vertically when using --list flag by @m-haisham in https://github.com/uutils/coreutils/pull/6201

### ls
* Compute the correct exit code by @BenWiederhake in https://github.com/uutils/coreutils/pull/6173

### mktemp
* Adjust the error message to match 9.5 by @sylvestre in https://github.com/uutils/coreutils/pull/6146

### more
* Use dev tty instead of mio to avoid panics by @apatrushev in https://github.com/uutils/coreutils/pull/6262

### mv
* Fix bug on Redox OS introduced by xattr handling by @dahc in https://github.com/uutils/coreutils/pull/6215

### od
* Remove `print_width_block` field of `OutputInfo` by @cakebaker in https://github.com/uutils/coreutils/pull/6239

### seq
* Removed zero-padding of string when parsing with parse_exponent_no_decimal by @maxer137 in https://github.com/uutils/coreutils/pull/6185
* Add the unit test even if they are failing for now by @sylvestre in https://github.com/uutils/coreutils/pull/6236

### tail
* Allow multiple usage of --pid to match upstream (regression of … by @sylvestre in https://github.com/uutils/coreutils/pull/6147

### tee
* Correctly handle read-only files, avoid unnecessary wrapping by @BenWiederhake in https://github.com/uutils/coreutils/pull/6157

### tr
* Fix "space" class, test "blank" class for order by @BenWiederhake in https://github.com/uutils/coreutils/pull/6141

### uniq
* Print version and help on stdout again by @tertsdiepraam in https://github.com/uutils/coreutils/pull/6123

### wc
* Count ASCII control characters as word characters by @BenWiederhake in https://github.com/uutils/coreutils/pull/6199

### Misc

* Initial AIX support by @ecnelises in https://github.com/uutils/coreutils/pull/6209
* Fix warning when executing Clippy by @bin-ly in https://github.com/uutils/coreutils/pull/6246
* tests: fix deprecation warning `timestamp_subsec_nanos()` by @mvo5 in https://github.com/uutils/coreutils/pull/6149
* tests: test multi-call logic by @BenWiederhake in https://github.com/uutils/coreutils/pull/6198
* all: Undo custom exit codes by @BenWiederhake in https://github.com/uutils/coreutils/pull/6162
* Cargo.toml: remove unnecessary caret by @cakebaker in https://github.com/uutils/coreutils/pull/6128
* Fixing the build issue on NetBSD by @jadijadi in https://github.com/uutils/coreutils/pull/6268
* Try to release 0.0.26 to see if the artifacts are generated by @sylvestre in https://github.com/uutils/coreutils/pull/6131
* Fix clippy warning match_bool  by @sylvestre in https://github.com/uutils/coreutils/pull/6184
* Minor nits in the tests by @sylvestre in https://github.com/uutils/coreutils/pull/6258

### Security
* fuzz: also generate the empty string sometimes by @BenWiederhake in https://github.com/uutils/coreutils/pull/6176
* add env & tr fuzzers + small improvs by @sylvestre in https://github.com/uutils/coreutils/pull/6167
* seq: fuzz PreciseNumber::from_str by @sylvestre in https://github.com/uutils/coreutils/pull/6183

### Documentation

* Doc: Explain that it is allowed to look at OpenBSD or Apple sources by @sylvestre in https://github.com/uutils/coreutils/pull/6140
* Readme: fix links to docs by @cakebaker in https://github.com/uutils/coreutils/pull/6189
### CI
* upgrade to GNU coreutils 9.5 as ref by @sylvestre in https://github.com/uutils/coreutils/pull/6139
* don't upgrade packages - msys2-runtime upgrade fails in CI by @cre4ture in https://github.com/uutils/coreutils/pull/6153
* fix macos ci instability on clippy with retry by @cre4ture in https://github.com/uutils/coreutils/pull/6156
* CI: change publish step condition by @tertsdiepraam in https://github.com/uutils/coreutils/pull/6181
* CI fix: use features arg for stable and nightly build by @cre4ture in https://github.com/uutils/coreutils/pull/6224
* feat(github): add CICD job build_programs_individually by @gierens in https://github.com/uutils/coreutils/pull/6212
* show-utils.sh: fix jq query by @tertsdiepraam in https://github.com/uutils/coreutils/pull/6120
* ci: use `-pcoreutils` when running clippy by @cakebaker in https://github.com/uutils/coreutils/pull/6247
* fix/CI ~ re-enable artifact deployment for version tagged commits by @rivy in https://github.com/uutils/coreutils/pull/6270
* android CI: incremental install when retry by @cre4ture in https://github.com/uutils/coreutils/pull/6274

### Dependencies
* chore(deps): update rust crate rayon to 1.10 by @renovate in https://github.com/uutils/coreutils/pull/6118
* chore(deps): drop conv dev-dependency by @paolobarbolini in https://github.com/uutils/coreutils/pull/6161
* chore(deps): update rust crate chrono to 0.4.37 by @renovate in https://github.com/uutils/coreutils/pull/6136
* chore(deps): update rust crate winapi-util to 0.1.7 by @renovate in https://github.com/uutils/coreutils/pull/6264
* chore(deps): update rust crate zip to 1.1.1 by @renovate in https://github.com/uutils/coreutils/pull/6257
* chore(deps): update rust crate zip to v1 by @renovate in https://github.com/uutils/coreutils/pull/6255
* chore(deps): update rust crate chrono to 0.4.38 by @renovate in https://github.com/uutils/coreutils/pull/6238
* chore(deps): update vmactions/freebsd-vm action to v1.0.7 by @renovate in https://github.com/uutils/coreutils/pull/6196
* chore(deps): update davidanson/markdownlint-cli2-action action to v16 by @renovate in https://github.com/uutils/coreutils/pull/6205
* chore(deps): update rust crate rstest to 0.19.0 by @renovate in https://github.com/uutils/coreutils/pull/6206
* chore(deps): update rust crate rust-ini to 0.21.0 by @renovate in https://github.com/uutils/coreutils/pull/5460
* chore(deps): update rust crate platform-info to 2.0.3 by @renovate in https://github.com/uutils/coreutils/pull/6214
* chore(deps): update rust crate bytecount to 0.6.8 by @renovate in https://github.com/uutils/coreutils/pull/6253
* chore(deps): update rust crate winapi-util to 0.1.8 by @renovate in https://github.com/uutils/coreutils/pull/6271

## New Contributors
* @LucasLarson made their first contribution in https://github.com/uutils/coreutils/pull/6135
* @mvo5 made their first contribution in https://github.com/uutils/coreutils/pull/6149
* @paolobarbolini made their first contribution in https://github.com/uutils/coreutils/pull/6161
* @jadijadi made their first contribution in https://github.com/uutils/coreutils/pull/6187
* @m-haisham made their first contribution in https://github.com/uutils/coreutils/pull/6201
* @maxer137 made their first contribution in https://github.com/uutils/coreutils/pull/6185
* @ecnelises made their first contribution in https://github.com/uutils/coreutils/pull/6209
* @dahc made their first contribution in https://github.com/uutils/coreutils/pull/6215
* @bin-ly made their first contribution in https://github.com/uutils/coreutils/pull/6246
* @gierens made their first contribution in https://github.com/uutils/coreutils/pull/6212
* @AnirbanHalder654322 made their first contribution in https://github.com/uutils/coreutils/pull/6220
* @apatrushev made their first contribution in https://github.com/uutils/coreutils/pull/6262

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.25...0.0.26
