#!/bin/sh
#
# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later

myself="$(readlink -f -- "$0")"
test_dir="$(dirname -- "$myself")"
. "$test_dir/tap-functions.sh"

[ -z "$PRIPS" ] && PRIPS='./prips'

plan_ 8

v=`$PRIPS -d33 17.1.0.40/30 2>/dev/null`
res="$?"
exp='17.1.0.40!17.1.0.41!17.1.0.42!17.1.0.43!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -f dot 17.1.0.40/30 2>/dev/null`
res="$?"
exp='17.1.0.40!17.1.0.41!17.1.0.42!17.1.0.43!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -f hex 17.1.0.40/30 2>/dev/null`
res="$?"
exp='11010028!11010029!1101002a!1101002b!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -f dec 17.1.0.40/30 2>/dev/null`
res="$?"
exp='285278248!285278249!285278250!285278251!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi
