// Copyright 2025 the Fearless_SIMD Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated by fearless_simd_gen

use crate::{
    Bytes, Level, Select, SimdCvtFloat, SimdCvtTruncate, SimdElement, SimdFrom, SimdInto,
    seal::Seal,
};
use crate::{
    f32x4, f32x8, f32x16, f64x2, f64x4, f64x8, i8x16, i8x32, i8x64, i16x8, i16x16, i16x32, i32x4,
    i32x8, i32x16, mask8x16, mask8x32, mask8x64, mask16x8, mask16x16, mask16x32, mask32x4,
    mask32x8, mask32x16, mask64x2, mask64x4, mask64x8, u8x16, u8x32, u8x64, u16x8, u16x16, u16x32,
    u32x4, u32x8, u32x16,
};
#[doc = r" TODO: docstring"]
pub trait Simd: Sized + Clone + Copy + Send + Sync + Seal + 'static {
    type f32s: SimdFloat<
            f32,
            Self,
            Block = f32x4<Self>,
            Mask = Self::mask32s,
            Bytes = <Self::u32s as Bytes>::Bytes,
        > + SimdCvtFloat<Self::u32s>
        + SimdCvtFloat<Self::i32s>;
    type u8s: SimdInt<u8, Self, Block = u8x16<Self>, Mask = Self::mask8s>;
    type i8s: SimdInt<
            i8,
            Self,
            Block = i8x16<Self>,
            Mask = Self::mask8s,
            Bytes = <Self::u8s as Bytes>::Bytes,
        > + core::ops::Neg<Output = Self::i8s>;
    type u16s: SimdInt<u16, Self, Block = u16x8<Self>, Mask = Self::mask16s>;
    type i16s: SimdInt<
            i16,
            Self,
            Block = i16x8<Self>,
            Mask = Self::mask16s,
            Bytes = <Self::u16s as Bytes>::Bytes,
        > + core::ops::Neg<Output = Self::i16s>;
    type u32s: SimdInt<u32, Self, Block = u32x4<Self>, Mask = Self::mask32s>
        + SimdCvtTruncate<Self::f32s>;
    type i32s: SimdInt<
            i32,
            Self,
            Block = i32x4<Self>,
            Mask = Self::mask32s,
            Bytes = <Self::u32s as Bytes>::Bytes,
        > + SimdCvtTruncate<Self::f32s>
        + core::ops::Neg<Output = Self::i32s>;
    type mask8s: SimdMask<i8, Self, Block = mask8x16<Self>, Bytes = <Self::u8s as Bytes>::Bytes>
        + Select<Self::u8s>
        + Select<Self::i8s>
        + Select<Self::mask8s>;
    type mask16s: SimdMask<i16, Self, Block = mask16x8<Self>, Bytes = <Self::u16s as Bytes>::Bytes>
        + Select<Self::u16s>
        + Select<Self::i16s>
        + Select<Self::mask16s>;
    type mask32s: SimdMask<i32, Self, Block = mask32x4<Self>, Bytes = <Self::u32s as Bytes>::Bytes>
        + Select<Self::f32s>
        + Select<Self::u32s>
        + Select<Self::i32s>
        + Select<Self::mask32s>;
    fn level(self) -> Level;
    #[doc = r" Call function with CPU features enabled."]
    #[doc = r""]
    #[doc = r" For performance, the provided function should be `#[inline(always)]`."]
    fn vectorize<F: FnOnce() -> R, R>(self, f: F) -> R;
    fn splat_f32x4(self, val: f32) -> f32x4<Self>;
    fn abs_f32x4(self, a: f32x4<Self>) -> f32x4<Self>;
    fn neg_f32x4(self, a: f32x4<Self>) -> f32x4<Self>;
    fn sqrt_f32x4(self, a: f32x4<Self>) -> f32x4<Self>;
    fn add_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn sub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn mul_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn div_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn copysign_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn simd_eq_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self>;
    fn simd_lt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self>;
    fn simd_le_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self>;
    fn simd_ge_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self>;
    fn simd_gt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self>;
    fn zip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn zip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn unzip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn unzip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn max_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn max_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn min_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn min_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self>;
    fn madd_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self>;
    fn msub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self>;
    fn floor_f32x4(self, a: f32x4<Self>) -> f32x4<Self>;
    fn fract_f32x4(self, a: f32x4<Self>) -> f32x4<Self>;
    fn trunc_f32x4(self, a: f32x4<Self>) -> f32x4<Self>;
    fn select_f32x4(self, a: mask32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self>;
    fn combine_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x8<Self>;
    fn reinterpret_f64_f32x4(self, a: f32x4<Self>) -> f64x2<Self>;
    fn reinterpret_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self>;
    fn reinterpret_u8_f32x4(self, a: f32x4<Self>) -> u8x16<Self>;
    fn reinterpret_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self>;
    fn cvt_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self>;
    fn cvt_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self>;
    fn splat_i8x16(self, val: i8) -> i8x16<Self>;
    fn not_i8x16(self, a: i8x16<Self>) -> i8x16<Self>;
    fn add_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn sub_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn mul_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn and_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn or_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn xor_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn shr_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self>;
    fn shrv_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn shl_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self>;
    fn simd_eq_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self>;
    fn simd_lt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self>;
    fn simd_le_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self>;
    fn simd_ge_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self>;
    fn simd_gt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self>;
    fn zip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn zip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn unzip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn unzip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn select_i8x16(self, a: mask8x16<Self>, b: i8x16<Self>, c: i8x16<Self>) -> i8x16<Self>;
    fn min_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn max_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self>;
    fn combine_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x32<Self>;
    fn neg_i8x16(self, a: i8x16<Self>) -> i8x16<Self>;
    fn reinterpret_u8_i8x16(self, a: i8x16<Self>) -> u8x16<Self>;
    fn reinterpret_u32_i8x16(self, a: i8x16<Self>) -> u32x4<Self>;
    fn splat_u8x16(self, val: u8) -> u8x16<Self>;
    fn not_u8x16(self, a: u8x16<Self>) -> u8x16<Self>;
    fn add_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn sub_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn mul_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn and_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn or_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn xor_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn shr_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self>;
    fn shrv_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn shl_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self>;
    fn simd_eq_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self>;
    fn simd_lt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self>;
    fn simd_le_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self>;
    fn simd_ge_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self>;
    fn simd_gt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self>;
    fn zip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn zip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn unzip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn unzip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn select_u8x16(self, a: mask8x16<Self>, b: u8x16<Self>, c: u8x16<Self>) -> u8x16<Self>;
    fn min_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn max_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self>;
    fn combine_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x32<Self>;
    fn widen_u8x16(self, a: u8x16<Self>) -> u16x16<Self>;
    fn reinterpret_u32_u8x16(self, a: u8x16<Self>) -> u32x4<Self>;
    fn splat_mask8x16(self, val: i8) -> mask8x16<Self>;
    fn not_mask8x16(self, a: mask8x16<Self>) -> mask8x16<Self>;
    fn and_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self>;
    fn or_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self>;
    fn xor_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self>;
    fn select_mask8x16(
        self,
        a: mask8x16<Self>,
        b: mask8x16<Self>,
        c: mask8x16<Self>,
    ) -> mask8x16<Self>;
    fn simd_eq_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self>;
    fn combine_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x32<Self>;
    fn splat_i16x8(self, val: i16) -> i16x8<Self>;
    fn not_i16x8(self, a: i16x8<Self>) -> i16x8<Self>;
    fn add_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn sub_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn mul_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn and_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn or_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn xor_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn shr_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self>;
    fn shrv_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn shl_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self>;
    fn simd_eq_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self>;
    fn simd_lt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self>;
    fn simd_le_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self>;
    fn simd_ge_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self>;
    fn simd_gt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self>;
    fn zip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn zip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn unzip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn unzip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn select_i16x8(self, a: mask16x8<Self>, b: i16x8<Self>, c: i16x8<Self>) -> i16x8<Self>;
    fn min_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn max_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self>;
    fn combine_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x16<Self>;
    fn neg_i16x8(self, a: i16x8<Self>) -> i16x8<Self>;
    fn reinterpret_u8_i16x8(self, a: i16x8<Self>) -> u8x16<Self>;
    fn reinterpret_u32_i16x8(self, a: i16x8<Self>) -> u32x4<Self>;
    fn splat_u16x8(self, val: u16) -> u16x8<Self>;
    fn not_u16x8(self, a: u16x8<Self>) -> u16x8<Self>;
    fn add_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn sub_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn mul_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn and_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn or_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn xor_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn shr_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self>;
    fn shrv_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn shl_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self>;
    fn simd_eq_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self>;
    fn simd_lt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self>;
    fn simd_le_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self>;
    fn simd_ge_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self>;
    fn simd_gt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self>;
    fn zip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn zip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn unzip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn unzip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn select_u16x8(self, a: mask16x8<Self>, b: u16x8<Self>, c: u16x8<Self>) -> u16x8<Self>;
    fn min_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn max_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self>;
    fn combine_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x16<Self>;
    fn reinterpret_u8_u16x8(self, a: u16x8<Self>) -> u8x16<Self>;
    fn reinterpret_u32_u16x8(self, a: u16x8<Self>) -> u32x4<Self>;
    fn splat_mask16x8(self, val: i16) -> mask16x8<Self>;
    fn not_mask16x8(self, a: mask16x8<Self>) -> mask16x8<Self>;
    fn and_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self>;
    fn or_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self>;
    fn xor_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self>;
    fn select_mask16x8(
        self,
        a: mask16x8<Self>,
        b: mask16x8<Self>,
        c: mask16x8<Self>,
    ) -> mask16x8<Self>;
    fn simd_eq_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self>;
    fn combine_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x16<Self>;
    fn splat_i32x4(self, val: i32) -> i32x4<Self>;
    fn not_i32x4(self, a: i32x4<Self>) -> i32x4<Self>;
    fn add_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn sub_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn mul_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn and_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn or_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn xor_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn shr_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self>;
    fn shrv_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn shl_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self>;
    fn simd_eq_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self>;
    fn simd_lt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self>;
    fn simd_le_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self>;
    fn simd_ge_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self>;
    fn simd_gt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self>;
    fn zip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn zip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn unzip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn unzip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn select_i32x4(self, a: mask32x4<Self>, b: i32x4<Self>, c: i32x4<Self>) -> i32x4<Self>;
    fn min_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn max_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self>;
    fn combine_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x8<Self>;
    fn neg_i32x4(self, a: i32x4<Self>) -> i32x4<Self>;
    fn reinterpret_u8_i32x4(self, a: i32x4<Self>) -> u8x16<Self>;
    fn reinterpret_u32_i32x4(self, a: i32x4<Self>) -> u32x4<Self>;
    fn cvt_f32_i32x4(self, a: i32x4<Self>) -> f32x4<Self>;
    fn splat_u32x4(self, val: u32) -> u32x4<Self>;
    fn not_u32x4(self, a: u32x4<Self>) -> u32x4<Self>;
    fn add_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn sub_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn mul_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn and_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn or_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn xor_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn shr_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self>;
    fn shrv_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn shl_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self>;
    fn simd_eq_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self>;
    fn simd_lt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self>;
    fn simd_le_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self>;
    fn simd_ge_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self>;
    fn simd_gt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self>;
    fn zip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn zip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn unzip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn unzip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn select_u32x4(self, a: mask32x4<Self>, b: u32x4<Self>, c: u32x4<Self>) -> u32x4<Self>;
    fn min_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn max_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self>;
    fn combine_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x8<Self>;
    fn reinterpret_u8_u32x4(self, a: u32x4<Self>) -> u8x16<Self>;
    fn cvt_f32_u32x4(self, a: u32x4<Self>) -> f32x4<Self>;
    fn splat_mask32x4(self, val: i32) -> mask32x4<Self>;
    fn not_mask32x4(self, a: mask32x4<Self>) -> mask32x4<Self>;
    fn and_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self>;
    fn or_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self>;
    fn xor_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self>;
    fn select_mask32x4(
        self,
        a: mask32x4<Self>,
        b: mask32x4<Self>,
        c: mask32x4<Self>,
    ) -> mask32x4<Self>;
    fn simd_eq_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self>;
    fn combine_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x8<Self>;
    fn splat_f64x2(self, val: f64) -> f64x2<Self>;
    fn abs_f64x2(self, a: f64x2<Self>) -> f64x2<Self>;
    fn neg_f64x2(self, a: f64x2<Self>) -> f64x2<Self>;
    fn sqrt_f64x2(self, a: f64x2<Self>) -> f64x2<Self>;
    fn add_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn sub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn mul_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn div_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn copysign_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn simd_eq_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self>;
    fn simd_lt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self>;
    fn simd_le_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self>;
    fn simd_ge_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self>;
    fn simd_gt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self>;
    fn zip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn zip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn unzip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn unzip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn max_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn max_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn min_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn min_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self>;
    fn madd_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self>;
    fn msub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self>;
    fn floor_f64x2(self, a: f64x2<Self>) -> f64x2<Self>;
    fn fract_f64x2(self, a: f64x2<Self>) -> f64x2<Self>;
    fn trunc_f64x2(self, a: f64x2<Self>) -> f64x2<Self>;
    fn select_f64x2(self, a: mask64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self>;
    fn combine_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x4<Self>;
    fn reinterpret_f32_f64x2(self, a: f64x2<Self>) -> f32x4<Self>;
    fn splat_mask64x2(self, val: i64) -> mask64x2<Self>;
    fn not_mask64x2(self, a: mask64x2<Self>) -> mask64x2<Self>;
    fn and_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self>;
    fn or_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self>;
    fn xor_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self>;
    fn select_mask64x2(
        self,
        a: mask64x2<Self>,
        b: mask64x2<Self>,
        c: mask64x2<Self>,
    ) -> mask64x2<Self>;
    fn simd_eq_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self>;
    fn combine_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x4<Self>;
    fn splat_f32x8(self, val: f32) -> f32x8<Self>;
    fn abs_f32x8(self, a: f32x8<Self>) -> f32x8<Self>;
    fn neg_f32x8(self, a: f32x8<Self>) -> f32x8<Self>;
    fn sqrt_f32x8(self, a: f32x8<Self>) -> f32x8<Self>;
    fn add_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn sub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn mul_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn div_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn copysign_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn simd_eq_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self>;
    fn simd_lt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self>;
    fn simd_le_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self>;
    fn simd_ge_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self>;
    fn simd_gt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self>;
    fn zip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn zip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn unzip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn unzip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn max_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn max_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn min_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn min_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self>;
    fn madd_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self>;
    fn msub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self>;
    fn floor_f32x8(self, a: f32x8<Self>) -> f32x8<Self>;
    fn fract_f32x8(self, a: f32x8<Self>) -> f32x8<Self>;
    fn trunc_f32x8(self, a: f32x8<Self>) -> f32x8<Self>;
    fn select_f32x8(self, a: mask32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self>;
    fn combine_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x16<Self>;
    fn split_f32x8(self, a: f32x8<Self>) -> (f32x4<Self>, f32x4<Self>);
    fn reinterpret_f64_f32x8(self, a: f32x8<Self>) -> f64x4<Self>;
    fn reinterpret_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self>;
    fn reinterpret_u8_f32x8(self, a: f32x8<Self>) -> u8x32<Self>;
    fn reinterpret_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self>;
    fn cvt_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self>;
    fn cvt_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self>;
    fn splat_i8x32(self, val: i8) -> i8x32<Self>;
    fn not_i8x32(self, a: i8x32<Self>) -> i8x32<Self>;
    fn add_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn sub_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn mul_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn and_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn or_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn xor_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn shr_i8x32(self, a: i8x32<Self>, shift: u32) -> i8x32<Self>;
    fn shrv_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn shl_i8x32(self, a: i8x32<Self>, shift: u32) -> i8x32<Self>;
    fn simd_eq_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self>;
    fn simd_lt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self>;
    fn simd_le_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self>;
    fn simd_ge_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self>;
    fn simd_gt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self>;
    fn zip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn zip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn unzip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn unzip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn select_i8x32(self, a: mask8x32<Self>, b: i8x32<Self>, c: i8x32<Self>) -> i8x32<Self>;
    fn min_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn max_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self>;
    fn combine_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x64<Self>;
    fn split_i8x32(self, a: i8x32<Self>) -> (i8x16<Self>, i8x16<Self>);
    fn neg_i8x32(self, a: i8x32<Self>) -> i8x32<Self>;
    fn reinterpret_u8_i8x32(self, a: i8x32<Self>) -> u8x32<Self>;
    fn reinterpret_u32_i8x32(self, a: i8x32<Self>) -> u32x8<Self>;
    fn splat_u8x32(self, val: u8) -> u8x32<Self>;
    fn not_u8x32(self, a: u8x32<Self>) -> u8x32<Self>;
    fn add_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn sub_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn mul_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn and_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn or_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn xor_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn shr_u8x32(self, a: u8x32<Self>, shift: u32) -> u8x32<Self>;
    fn shrv_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn shl_u8x32(self, a: u8x32<Self>, shift: u32) -> u8x32<Self>;
    fn simd_eq_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self>;
    fn simd_lt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self>;
    fn simd_le_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self>;
    fn simd_ge_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self>;
    fn simd_gt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self>;
    fn zip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn zip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn unzip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn unzip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn select_u8x32(self, a: mask8x32<Self>, b: u8x32<Self>, c: u8x32<Self>) -> u8x32<Self>;
    fn min_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn max_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self>;
    fn combine_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x64<Self>;
    fn split_u8x32(self, a: u8x32<Self>) -> (u8x16<Self>, u8x16<Self>);
    fn widen_u8x32(self, a: u8x32<Self>) -> u16x32<Self>;
    fn reinterpret_u32_u8x32(self, a: u8x32<Self>) -> u32x8<Self>;
    fn splat_mask8x32(self, val: i8) -> mask8x32<Self>;
    fn not_mask8x32(self, a: mask8x32<Self>) -> mask8x32<Self>;
    fn and_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self>;
    fn or_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self>;
    fn xor_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self>;
    fn select_mask8x32(
        self,
        a: mask8x32<Self>,
        b: mask8x32<Self>,
        c: mask8x32<Self>,
    ) -> mask8x32<Self>;
    fn simd_eq_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self>;
    fn combine_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x64<Self>;
    fn split_mask8x32(self, a: mask8x32<Self>) -> (mask8x16<Self>, mask8x16<Self>);
    fn splat_i16x16(self, val: i16) -> i16x16<Self>;
    fn not_i16x16(self, a: i16x16<Self>) -> i16x16<Self>;
    fn add_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn sub_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn mul_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn and_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn or_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn xor_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn shr_i16x16(self, a: i16x16<Self>, shift: u32) -> i16x16<Self>;
    fn shrv_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn shl_i16x16(self, a: i16x16<Self>, shift: u32) -> i16x16<Self>;
    fn simd_eq_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self>;
    fn simd_lt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self>;
    fn simd_le_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self>;
    fn simd_ge_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self>;
    fn simd_gt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self>;
    fn zip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn zip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn unzip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn unzip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn select_i16x16(self, a: mask16x16<Self>, b: i16x16<Self>, c: i16x16<Self>) -> i16x16<Self>;
    fn min_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn max_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self>;
    fn combine_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x32<Self>;
    fn split_i16x16(self, a: i16x16<Self>) -> (i16x8<Self>, i16x8<Self>);
    fn neg_i16x16(self, a: i16x16<Self>) -> i16x16<Self>;
    fn reinterpret_u8_i16x16(self, a: i16x16<Self>) -> u8x32<Self>;
    fn reinterpret_u32_i16x16(self, a: i16x16<Self>) -> u32x8<Self>;
    fn splat_u16x16(self, val: u16) -> u16x16<Self>;
    fn not_u16x16(self, a: u16x16<Self>) -> u16x16<Self>;
    fn add_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn sub_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn mul_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn and_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn or_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn xor_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn shr_u16x16(self, a: u16x16<Self>, shift: u32) -> u16x16<Self>;
    fn shrv_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn shl_u16x16(self, a: u16x16<Self>, shift: u32) -> u16x16<Self>;
    fn simd_eq_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self>;
    fn simd_lt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self>;
    fn simd_le_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self>;
    fn simd_ge_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self>;
    fn simd_gt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self>;
    fn zip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn zip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn unzip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn unzip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn select_u16x16(self, a: mask16x16<Self>, b: u16x16<Self>, c: u16x16<Self>) -> u16x16<Self>;
    fn min_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn max_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self>;
    fn combine_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x32<Self>;
    fn split_u16x16(self, a: u16x16<Self>) -> (u16x8<Self>, u16x8<Self>);
    fn narrow_u16x16(self, a: u16x16<Self>) -> u8x16<Self>;
    fn reinterpret_u8_u16x16(self, a: u16x16<Self>) -> u8x32<Self>;
    fn reinterpret_u32_u16x16(self, a: u16x16<Self>) -> u32x8<Self>;
    fn splat_mask16x16(self, val: i16) -> mask16x16<Self>;
    fn not_mask16x16(self, a: mask16x16<Self>) -> mask16x16<Self>;
    fn and_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self>;
    fn or_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self>;
    fn xor_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self>;
    fn select_mask16x16(
        self,
        a: mask16x16<Self>,
        b: mask16x16<Self>,
        c: mask16x16<Self>,
    ) -> mask16x16<Self>;
    fn simd_eq_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self>;
    fn combine_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x32<Self>;
    fn split_mask16x16(self, a: mask16x16<Self>) -> (mask16x8<Self>, mask16x8<Self>);
    fn splat_i32x8(self, val: i32) -> i32x8<Self>;
    fn not_i32x8(self, a: i32x8<Self>) -> i32x8<Self>;
    fn add_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn sub_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn mul_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn and_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn or_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn xor_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn shr_i32x8(self, a: i32x8<Self>, shift: u32) -> i32x8<Self>;
    fn shrv_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn shl_i32x8(self, a: i32x8<Self>, shift: u32) -> i32x8<Self>;
    fn simd_eq_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self>;
    fn simd_lt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self>;
    fn simd_le_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self>;
    fn simd_ge_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self>;
    fn simd_gt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self>;
    fn zip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn zip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn unzip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn unzip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn select_i32x8(self, a: mask32x8<Self>, b: i32x8<Self>, c: i32x8<Self>) -> i32x8<Self>;
    fn min_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn max_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self>;
    fn combine_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x16<Self>;
    fn split_i32x8(self, a: i32x8<Self>) -> (i32x4<Self>, i32x4<Self>);
    fn neg_i32x8(self, a: i32x8<Self>) -> i32x8<Self>;
    fn reinterpret_u8_i32x8(self, a: i32x8<Self>) -> u8x32<Self>;
    fn reinterpret_u32_i32x8(self, a: i32x8<Self>) -> u32x8<Self>;
    fn cvt_f32_i32x8(self, a: i32x8<Self>) -> f32x8<Self>;
    fn splat_u32x8(self, val: u32) -> u32x8<Self>;
    fn not_u32x8(self, a: u32x8<Self>) -> u32x8<Self>;
    fn add_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn sub_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn mul_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn and_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn or_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn xor_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn shr_u32x8(self, a: u32x8<Self>, shift: u32) -> u32x8<Self>;
    fn shrv_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn shl_u32x8(self, a: u32x8<Self>, shift: u32) -> u32x8<Self>;
    fn simd_eq_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self>;
    fn simd_lt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self>;
    fn simd_le_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self>;
    fn simd_ge_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self>;
    fn simd_gt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self>;
    fn zip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn zip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn unzip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn unzip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn select_u32x8(self, a: mask32x8<Self>, b: u32x8<Self>, c: u32x8<Self>) -> u32x8<Self>;
    fn min_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn max_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self>;
    fn combine_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x16<Self>;
    fn split_u32x8(self, a: u32x8<Self>) -> (u32x4<Self>, u32x4<Self>);
    fn reinterpret_u8_u32x8(self, a: u32x8<Self>) -> u8x32<Self>;
    fn cvt_f32_u32x8(self, a: u32x8<Self>) -> f32x8<Self>;
    fn splat_mask32x8(self, val: i32) -> mask32x8<Self>;
    fn not_mask32x8(self, a: mask32x8<Self>) -> mask32x8<Self>;
    fn and_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self>;
    fn or_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self>;
    fn xor_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self>;
    fn select_mask32x8(
        self,
        a: mask32x8<Self>,
        b: mask32x8<Self>,
        c: mask32x8<Self>,
    ) -> mask32x8<Self>;
    fn simd_eq_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self>;
    fn combine_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x16<Self>;
    fn split_mask32x8(self, a: mask32x8<Self>) -> (mask32x4<Self>, mask32x4<Self>);
    fn splat_f64x4(self, val: f64) -> f64x4<Self>;
    fn abs_f64x4(self, a: f64x4<Self>) -> f64x4<Self>;
    fn neg_f64x4(self, a: f64x4<Self>) -> f64x4<Self>;
    fn sqrt_f64x4(self, a: f64x4<Self>) -> f64x4<Self>;
    fn add_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn sub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn mul_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn div_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn copysign_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn simd_eq_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self>;
    fn simd_lt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self>;
    fn simd_le_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self>;
    fn simd_ge_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self>;
    fn simd_gt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self>;
    fn zip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn zip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn unzip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn unzip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn max_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn max_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn min_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn min_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self>;
    fn madd_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self>;
    fn msub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self>;
    fn floor_f64x4(self, a: f64x4<Self>) -> f64x4<Self>;
    fn fract_f64x4(self, a: f64x4<Self>) -> f64x4<Self>;
    fn trunc_f64x4(self, a: f64x4<Self>) -> f64x4<Self>;
    fn select_f64x4(self, a: mask64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self>;
    fn combine_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x8<Self>;
    fn split_f64x4(self, a: f64x4<Self>) -> (f64x2<Self>, f64x2<Self>);
    fn reinterpret_f32_f64x4(self, a: f64x4<Self>) -> f32x8<Self>;
    fn splat_mask64x4(self, val: i64) -> mask64x4<Self>;
    fn not_mask64x4(self, a: mask64x4<Self>) -> mask64x4<Self>;
    fn and_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self>;
    fn or_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self>;
    fn xor_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self>;
    fn select_mask64x4(
        self,
        a: mask64x4<Self>,
        b: mask64x4<Self>,
        c: mask64x4<Self>,
    ) -> mask64x4<Self>;
    fn simd_eq_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self>;
    fn combine_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x8<Self>;
    fn split_mask64x4(self, a: mask64x4<Self>) -> (mask64x2<Self>, mask64x2<Self>);
    fn splat_f32x16(self, val: f32) -> f32x16<Self>;
    fn abs_f32x16(self, a: f32x16<Self>) -> f32x16<Self>;
    fn neg_f32x16(self, a: f32x16<Self>) -> f32x16<Self>;
    fn sqrt_f32x16(self, a: f32x16<Self>) -> f32x16<Self>;
    fn add_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn sub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn mul_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn div_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn copysign_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn simd_eq_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self>;
    fn simd_lt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self>;
    fn simd_le_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self>;
    fn simd_ge_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self>;
    fn simd_gt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self>;
    fn zip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn zip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn unzip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn unzip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn max_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn max_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn min_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn min_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self>;
    fn madd_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self>;
    fn msub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self>;
    fn floor_f32x16(self, a: f32x16<Self>) -> f32x16<Self>;
    fn fract_f32x16(self, a: f32x16<Self>) -> f32x16<Self>;
    fn trunc_f32x16(self, a: f32x16<Self>) -> f32x16<Self>;
    fn select_f32x16(self, a: mask32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self>;
    fn split_f32x16(self, a: f32x16<Self>) -> (f32x8<Self>, f32x8<Self>);
    fn reinterpret_f64_f32x16(self, a: f32x16<Self>) -> f64x8<Self>;
    fn reinterpret_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self>;
    fn load_interleaved_128_f32x16(self, src: &[f32; 16usize]) -> f32x16<Self>;
    fn store_interleaved_128_f32x16(self, a: f32x16<Self>, dest: &mut [f32; 16usize]) -> ();
    fn reinterpret_u8_f32x16(self, a: f32x16<Self>) -> u8x64<Self>;
    fn reinterpret_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self>;
    fn cvt_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self>;
    fn cvt_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self>;
    fn splat_i8x64(self, val: i8) -> i8x64<Self>;
    fn not_i8x64(self, a: i8x64<Self>) -> i8x64<Self>;
    fn add_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn sub_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn mul_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn and_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn or_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn xor_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn shr_i8x64(self, a: i8x64<Self>, shift: u32) -> i8x64<Self>;
    fn shrv_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn shl_i8x64(self, a: i8x64<Self>, shift: u32) -> i8x64<Self>;
    fn simd_eq_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self>;
    fn simd_lt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self>;
    fn simd_le_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self>;
    fn simd_ge_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self>;
    fn simd_gt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self>;
    fn zip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn zip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn unzip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn unzip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn select_i8x64(self, a: mask8x64<Self>, b: i8x64<Self>, c: i8x64<Self>) -> i8x64<Self>;
    fn min_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn max_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self>;
    fn split_i8x64(self, a: i8x64<Self>) -> (i8x32<Self>, i8x32<Self>);
    fn neg_i8x64(self, a: i8x64<Self>) -> i8x64<Self>;
    fn reinterpret_u8_i8x64(self, a: i8x64<Self>) -> u8x64<Self>;
    fn reinterpret_u32_i8x64(self, a: i8x64<Self>) -> u32x16<Self>;
    fn splat_u8x64(self, val: u8) -> u8x64<Self>;
    fn not_u8x64(self, a: u8x64<Self>) -> u8x64<Self>;
    fn add_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn sub_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn mul_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn and_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn or_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn xor_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn shr_u8x64(self, a: u8x64<Self>, shift: u32) -> u8x64<Self>;
    fn shrv_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn shl_u8x64(self, a: u8x64<Self>, shift: u32) -> u8x64<Self>;
    fn simd_eq_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self>;
    fn simd_lt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self>;
    fn simd_le_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self>;
    fn simd_ge_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self>;
    fn simd_gt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self>;
    fn zip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn zip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn unzip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn unzip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn select_u8x64(self, a: mask8x64<Self>, b: u8x64<Self>, c: u8x64<Self>) -> u8x64<Self>;
    fn min_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn max_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self>;
    fn split_u8x64(self, a: u8x64<Self>) -> (u8x32<Self>, u8x32<Self>);
    fn load_interleaved_128_u8x64(self, src: &[u8; 64usize]) -> u8x64<Self>;
    fn store_interleaved_128_u8x64(self, a: u8x64<Self>, dest: &mut [u8; 64usize]) -> ();
    fn reinterpret_u32_u8x64(self, a: u8x64<Self>) -> u32x16<Self>;
    fn splat_mask8x64(self, val: i8) -> mask8x64<Self>;
    fn not_mask8x64(self, a: mask8x64<Self>) -> mask8x64<Self>;
    fn and_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self>;
    fn or_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self>;
    fn xor_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self>;
    fn select_mask8x64(
        self,
        a: mask8x64<Self>,
        b: mask8x64<Self>,
        c: mask8x64<Self>,
    ) -> mask8x64<Self>;
    fn simd_eq_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self>;
    fn split_mask8x64(self, a: mask8x64<Self>) -> (mask8x32<Self>, mask8x32<Self>);
    fn splat_i16x32(self, val: i16) -> i16x32<Self>;
    fn not_i16x32(self, a: i16x32<Self>) -> i16x32<Self>;
    fn add_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn sub_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn mul_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn and_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn or_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn xor_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn shr_i16x32(self, a: i16x32<Self>, shift: u32) -> i16x32<Self>;
    fn shrv_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn shl_i16x32(self, a: i16x32<Self>, shift: u32) -> i16x32<Self>;
    fn simd_eq_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self>;
    fn simd_lt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self>;
    fn simd_le_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self>;
    fn simd_ge_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self>;
    fn simd_gt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self>;
    fn zip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn zip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn unzip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn unzip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn select_i16x32(self, a: mask16x32<Self>, b: i16x32<Self>, c: i16x32<Self>) -> i16x32<Self>;
    fn min_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn max_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self>;
    fn split_i16x32(self, a: i16x32<Self>) -> (i16x16<Self>, i16x16<Self>);
    fn neg_i16x32(self, a: i16x32<Self>) -> i16x32<Self>;
    fn reinterpret_u8_i16x32(self, a: i16x32<Self>) -> u8x64<Self>;
    fn reinterpret_u32_i16x32(self, a: i16x32<Self>) -> u32x16<Self>;
    fn splat_u16x32(self, val: u16) -> u16x32<Self>;
    fn not_u16x32(self, a: u16x32<Self>) -> u16x32<Self>;
    fn add_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn sub_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn mul_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn and_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn or_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn xor_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn shr_u16x32(self, a: u16x32<Self>, shift: u32) -> u16x32<Self>;
    fn shrv_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn shl_u16x32(self, a: u16x32<Self>, shift: u32) -> u16x32<Self>;
    fn simd_eq_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self>;
    fn simd_lt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self>;
    fn simd_le_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self>;
    fn simd_ge_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self>;
    fn simd_gt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self>;
    fn zip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn zip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn unzip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn unzip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn select_u16x32(self, a: mask16x32<Self>, b: u16x32<Self>, c: u16x32<Self>) -> u16x32<Self>;
    fn min_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn max_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self>;
    fn split_u16x32(self, a: u16x32<Self>) -> (u16x16<Self>, u16x16<Self>);
    fn load_interleaved_128_u16x32(self, src: &[u16; 32usize]) -> u16x32<Self>;
    fn store_interleaved_128_u16x32(self, a: u16x32<Self>, dest: &mut [u16; 32usize]) -> ();
    fn narrow_u16x32(self, a: u16x32<Self>) -> u8x32<Self>;
    fn reinterpret_u8_u16x32(self, a: u16x32<Self>) -> u8x64<Self>;
    fn reinterpret_u32_u16x32(self, a: u16x32<Self>) -> u32x16<Self>;
    fn splat_mask16x32(self, val: i16) -> mask16x32<Self>;
    fn not_mask16x32(self, a: mask16x32<Self>) -> mask16x32<Self>;
    fn and_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self>;
    fn or_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self>;
    fn xor_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self>;
    fn select_mask16x32(
        self,
        a: mask16x32<Self>,
        b: mask16x32<Self>,
        c: mask16x32<Self>,
    ) -> mask16x32<Self>;
    fn simd_eq_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self>;
    fn split_mask16x32(self, a: mask16x32<Self>) -> (mask16x16<Self>, mask16x16<Self>);
    fn splat_i32x16(self, val: i32) -> i32x16<Self>;
    fn not_i32x16(self, a: i32x16<Self>) -> i32x16<Self>;
    fn add_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn sub_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn mul_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn and_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn or_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn xor_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn shr_i32x16(self, a: i32x16<Self>, shift: u32) -> i32x16<Self>;
    fn shrv_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn shl_i32x16(self, a: i32x16<Self>, shift: u32) -> i32x16<Self>;
    fn simd_eq_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self>;
    fn simd_lt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self>;
    fn simd_le_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self>;
    fn simd_ge_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self>;
    fn simd_gt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self>;
    fn zip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn zip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn unzip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn unzip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn select_i32x16(self, a: mask32x16<Self>, b: i32x16<Self>, c: i32x16<Self>) -> i32x16<Self>;
    fn min_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn max_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self>;
    fn split_i32x16(self, a: i32x16<Self>) -> (i32x8<Self>, i32x8<Self>);
    fn neg_i32x16(self, a: i32x16<Self>) -> i32x16<Self>;
    fn reinterpret_u8_i32x16(self, a: i32x16<Self>) -> u8x64<Self>;
    fn reinterpret_u32_i32x16(self, a: i32x16<Self>) -> u32x16<Self>;
    fn cvt_f32_i32x16(self, a: i32x16<Self>) -> f32x16<Self>;
    fn splat_u32x16(self, val: u32) -> u32x16<Self>;
    fn not_u32x16(self, a: u32x16<Self>) -> u32x16<Self>;
    fn add_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn sub_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn mul_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn and_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn or_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn xor_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn shr_u32x16(self, a: u32x16<Self>, shift: u32) -> u32x16<Self>;
    fn shrv_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn shl_u32x16(self, a: u32x16<Self>, shift: u32) -> u32x16<Self>;
    fn simd_eq_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self>;
    fn simd_lt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self>;
    fn simd_le_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self>;
    fn simd_ge_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self>;
    fn simd_gt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self>;
    fn zip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn zip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn unzip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn unzip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn select_u32x16(self, a: mask32x16<Self>, b: u32x16<Self>, c: u32x16<Self>) -> u32x16<Self>;
    fn min_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn max_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self>;
    fn split_u32x16(self, a: u32x16<Self>) -> (u32x8<Self>, u32x8<Self>);
    fn load_interleaved_128_u32x16(self, src: &[u32; 16usize]) -> u32x16<Self>;
    fn store_interleaved_128_u32x16(self, a: u32x16<Self>, dest: &mut [u32; 16usize]) -> ();
    fn reinterpret_u8_u32x16(self, a: u32x16<Self>) -> u8x64<Self>;
    fn cvt_f32_u32x16(self, a: u32x16<Self>) -> f32x16<Self>;
    fn splat_mask32x16(self, val: i32) -> mask32x16<Self>;
    fn not_mask32x16(self, a: mask32x16<Self>) -> mask32x16<Self>;
    fn and_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self>;
    fn or_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self>;
    fn xor_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self>;
    fn select_mask32x16(
        self,
        a: mask32x16<Self>,
        b: mask32x16<Self>,
        c: mask32x16<Self>,
    ) -> mask32x16<Self>;
    fn simd_eq_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self>;
    fn split_mask32x16(self, a: mask32x16<Self>) -> (mask32x8<Self>, mask32x8<Self>);
    fn splat_f64x8(self, val: f64) -> f64x8<Self>;
    fn abs_f64x8(self, a: f64x8<Self>) -> f64x8<Self>;
    fn neg_f64x8(self, a: f64x8<Self>) -> f64x8<Self>;
    fn sqrt_f64x8(self, a: f64x8<Self>) -> f64x8<Self>;
    fn add_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn sub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn mul_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn div_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn copysign_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn simd_eq_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self>;
    fn simd_lt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self>;
    fn simd_le_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self>;
    fn simd_ge_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self>;
    fn simd_gt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self>;
    fn zip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn zip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn unzip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn unzip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn max_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn max_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn min_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn min_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self>;
    fn madd_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self>;
    fn msub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self>;
    fn floor_f64x8(self, a: f64x8<Self>) -> f64x8<Self>;
    fn fract_f64x8(self, a: f64x8<Self>) -> f64x8<Self>;
    fn trunc_f64x8(self, a: f64x8<Self>) -> f64x8<Self>;
    fn select_f64x8(self, a: mask64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self>;
    fn split_f64x8(self, a: f64x8<Self>) -> (f64x4<Self>, f64x4<Self>);
    fn reinterpret_f32_f64x8(self, a: f64x8<Self>) -> f32x16<Self>;
    fn splat_mask64x8(self, val: i64) -> mask64x8<Self>;
    fn not_mask64x8(self, a: mask64x8<Self>) -> mask64x8<Self>;
    fn and_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self>;
    fn or_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self>;
    fn xor_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self>;
    fn select_mask64x8(
        self,
        a: mask64x8<Self>,
        b: mask64x8<Self>,
        c: mask64x8<Self>,
    ) -> mask64x8<Self>;
    fn simd_eq_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self>;
    fn split_mask64x8(self, a: mask64x8<Self>) -> (mask64x4<Self>, mask64x4<Self>);
}
pub trait SimdBase<Element: SimdElement, S: Simd>:
    Copy + Sync + Send + 'static + crate::Bytes + SimdFrom<Element, S>
{
    const N: usize;
    #[doc = r" A SIMD vector mask with the same number of elements."]
    #[doc = r""]
    #[doc = r" The mask element is represented as an integer which is"]
    #[doc = r" all-0 for `false` and all-1 for `true`. When we get deep"]
    #[doc = r" into AVX-512, we need to think about predication masks."]
    #[doc = r""]
    #[doc = r" One possibility to consider is that the SIMD trait grows"]
    #[doc = r" `maskAxB` associated types."]
    type Mask: SimdMask<Element::Mask, S>;
    #[doc = r" A 128 bit SIMD vector of the same scalar type."]
    type Block: SimdBase<Element, S>;
    #[doc = r" Get the [`Simd`] implementation associated with this type."]
    fn witness(&self) -> S;
    fn as_slice(&self) -> &[Element];
    fn as_mut_slice(&mut self) -> &mut [Element];
    #[doc = r" Create a SIMD vector from a slice."]
    #[doc = r""]
    #[doc = r" The slice must be the proper width."]
    fn from_slice(simd: S, slice: &[Element]) -> Self;
    fn splat(simd: S, val: Element) -> Self;
    fn block_splat(block: Self::Block) -> Self;
}
pub trait SimdFloat<Element: SimdElement, S: Simd>:
    SimdBase<Element, S>
    + core::ops::Neg<Output = Self>
    + core::ops::Add<Output = Self>
    + core::ops::AddAssign
    + core::ops::Add<Element, Output = Self>
    + core::ops::AddAssign<Element>
    + core::ops::Sub<Output = Self>
    + core::ops::SubAssign
    + core::ops::Sub<Element, Output = Self>
    + core::ops::SubAssign<Element>
    + core::ops::Mul<Output = Self>
    + core::ops::MulAssign
    + core::ops::Mul<Element, Output = Self>
    + core::ops::MulAssign<Element>
    + core::ops::Div<Output = Self>
    + core::ops::DivAssign
    + core::ops::Div<Element, Output = Self>
    + core::ops::DivAssign<Element>
{
    #[inline(always)]
    fn to_int<T: SimdCvtTruncate<Self>>(self) -> T {
        T::truncate_from(self)
    }
    fn abs(self) -> Self;
    fn sqrt(self) -> Self;
    fn copysign(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn simd_eq(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_lt(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_le(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_ge(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_gt(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn zip_low(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn zip_high(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn unzip_low(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn unzip_high(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn max(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn max_precise(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn min(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn min_precise(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn madd(self, op1: impl SimdInto<Self, S>, op2: impl SimdInto<Self, S>) -> Self;
    fn msub(self, op1: impl SimdInto<Self, S>, op2: impl SimdInto<Self, S>) -> Self;
    fn floor(self) -> Self;
    fn fract(self) -> Self;
    fn trunc(self) -> Self;
}
pub trait SimdInt<Element: SimdElement, S: Simd>:
    SimdBase<Element, S>
    + core::ops::Add<Output = Self>
    + core::ops::AddAssign
    + core::ops::Add<Element, Output = Self>
    + core::ops::AddAssign<Element>
    + core::ops::Sub<Output = Self>
    + core::ops::SubAssign
    + core::ops::Sub<Element, Output = Self>
    + core::ops::SubAssign<Element>
    + core::ops::Mul<Output = Self>
    + core::ops::MulAssign
    + core::ops::Mul<Element, Output = Self>
    + core::ops::MulAssign<Element>
    + core::ops::BitAnd<Output = Self>
    + core::ops::BitAndAssign
    + core::ops::BitAnd<Element, Output = Self>
    + core::ops::BitAndAssign<Element>
    + core::ops::BitOr<Output = Self>
    + core::ops::BitOrAssign
    + core::ops::BitOr<Element, Output = Self>
    + core::ops::BitOrAssign<Element>
    + core::ops::BitXor<Output = Self>
    + core::ops::BitXorAssign
    + core::ops::BitXor<Element, Output = Self>
    + core::ops::BitXorAssign<Element>
    + core::ops::Shl<u32, Output = Self>
    + core::ops::ShlAssign<u32>
    + core::ops::Shr<Output = Self>
    + core::ops::ShrAssign
    + core::ops::Shr<u32, Output = Self>
    + core::ops::ShrAssign<u32>
{
    #[inline(always)]
    fn to_float<T: SimdCvtFloat<Self>>(self) -> T {
        T::float_from(self)
    }
    fn simd_eq(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_lt(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_le(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_ge(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn simd_gt(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
    fn zip_low(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn zip_high(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn unzip_low(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn unzip_high(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn min(self, rhs: impl SimdInto<Self, S>) -> Self;
    fn max(self, rhs: impl SimdInto<Self, S>) -> Self;
}
pub trait SimdMask<Element: SimdElement, S: Simd>:
    SimdBase<Element, S>
    + core::ops::Not<Output = Self>
    + core::ops::BitAnd<Output = Self>
    + core::ops::BitOr<Output = Self>
    + core::ops::BitXor<Output = Self>
{
    fn simd_eq(self, rhs: impl SimdInto<Self, S>) -> Self::Mask;
}
