% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.R
\name{sim.phreg}
\alias{sim.phreg}
\alias{draw.phreg}
\alias{setup.phreg}
\title{Simulation of output from Cox model.}
\usage{
sim.phreg(
  cox,
  n,
  data = NULL,
  Z = NULL,
  rr = NULL,
  strata = NULL,
  entry = NULL,
  extend = NULL,
  cens = NULL,
  rrc = NULL,
  ...
)
}
\arguments{
\item{cox}{output form coxph or cox.aalen model fitting cox model.}

\item{n}{number of simulations.}

\item{data}{to extract covariates for simulations (draws from observed covariates).}

\item{Z}{give design matrix instead of data}

\item{rr}{possible vector of relative risk for cox model.}

\item{strata}{possible vector of strata}

\item{entry}{delayed entry variable for simulation.}

\item{extend}{to extend possible stratified baselines to largest end-point 
given then takes average rate of in simulated data from cox model.}

\item{cens}{specifies censoring model, if "is.matrix" then uses cumulative
hazard given, if "is.scalar" then uses rate for exponential, and if not}

\item{rrc}{possible vector of relative risk for cox-type censoring.}

\item{...}{arguments for rchaz, for example entry-time.}
}
\description{
Simulates data that looks like fit from Cox model. Censor data automatically
for highest value of the event times by using cumulative hazard.
}
\examples{
library(mets)
data(sTRACE)
nsim <- 100
coxs <-  phreg(Surv(time,status==9)~strata(chf)+vf+wmi,data=sTRACE)
set.seed(100)
sim3 <- sim.phreg(coxs,nsim,data=sTRACE)
head(sim3)
cc <-   phreg(Surv(time,status)~strata(chf)+vf+wmi,data=sim3)
cbind(coxs$coef,cc$coef)
plot(coxs,col=1); plot(cc,add=TRUE,col=2)

Z <- sim3[,c("vf","chf","wmi")]
strata <- sim3[,c("chf")]
rr <- exp(as.matrix(Z[,-2]) \%*\% coef(coxs))
sim4 <- sim.phreg(coxs,nsim,data=NULL,rr=rr,strata=strata)
sim4 <- cbind(sim4,Z)
cc <-   phreg(Surv(time,status)~strata(chf)+vf+wmi,data=sim4)
cbind(coxs$coef,cc$coef)
plot(coxs,col=1); plot(cc,add=TRUE,col=2)

}
\author{
Thomas Scheike
}
\keyword{survival}
