% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout.sugiyama}
\alias{layout.sugiyama}
\title{The Sugiyama graph layout generator}
\usage{
layout.sugiyama(
  graph,
  layers = NULL,
  hgap = 1,
  vgap = 1,
  maxiter = 100,
  weights = NULL,
  attributes = c("default", "all", "none")
)
}
\arguments{
\item{graph}{The input graph.}

\item{layers}{A numeric vector or \code{NULL}. If not \code{NULL}, then it
should specify the layer index of the vertices. Layers are numbered from
one. If \code{NULL}, then igraph calculates the layers automatically.}

\item{hgap}{Real scalar, the minimum horizontal gap between vertices in the
same layer.}

\item{vgap}{Real scalar, the distance between layers.}

\item{maxiter}{Integer scalar, the maximum number of iterations in the
crossing minimization stage. 100 is a reasonable default; if you feel that
you have too many edge crossings, increase this.}

\item{weights}{Optional edge weight vector. If \code{NULL}, then the
'weight' edge attribute is used, if there is one. Supply \code{NA} here and
igraph ignores the edge weights. These are used only if the graph
contains cycles; igraph will tend to reverse edges with smaller weights
when breaking the cycles.}

\item{attributes}{Which graph/vertex/edge attributes to keep in the extended
graph. \sQuote{default} keeps the \sQuote{size}, \sQuote{size2},
\sQuote{shape}, \sQuote{label} and \sQuote{color} vertex attributes and the
\sQuote{arrow.mode} and \sQuote{arrow.size} edge attributes. \sQuote{all}
keep all graph, vertex and edge attributes, \sQuote{none} keeps none of
them.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{layout.sugiyama()} was renamed to \code{\link[=layout_with_sugiyama]{layout_with_sugiyama()}} to create a more
consistent API.
}
\keyword{internal}
