// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QMenuBar>
#include <QMenu>

namespace Ui {
    class Widget;
}

class Widget : public QWidget {
    Q_OBJECT
public:
    Widget(QWidget *parent = nullptr);
    ~Widget();

public slots:
    void switchToFullScreen();
    void switchToNormalScreen();
    void addMenuBar();
    void removeMenuBar();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::Widget *ui;
    QMenuBar *menuBar;
};

#endif // WIDGET_H
