%feature("docstring") OT::MultinomialFactory
R"RAW(Multinomial factory.

Notes
-----
The parameters :math:`N` and :math:`p=(p_1,\dots,p_d)` are estimated using their
maximum likelihood estimators:

.. math::
    :nowrap:

    \begin{eqnarray*}
      data : (\vect{x}^1, \hdots,\vect{x}^n)\\
      N = \max_{k} \sum_{i=1}^d x_i^k\\
      p_i = \frac{1}{nN} \sum_{k=1}^{n} x_i^k
    \end{eqnarray*}

Remember that the OpenTURNS multinomial distribution is such that
:math:`\sum_{k=1}^d X_i\leq N`.

See also
--------
DistributionFactory, Multinomial)RAW"


// ---------------------------------------------------------------------

%feature("docstring") OT::MultinomialFactory::buildAsMultinomial
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsMultinomial()

    buildAsMultinomial(*sample*)

    buildAsMultinomial(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
   The parameters of the :class:`~openturns.Multinomial`.

Returns
-------
distribution : :class:`~openturns.Multinomial`
    The estimated distribution as a Multinomial.
    
    In the first usage, the default Multinomial distribution is built."

