# Copyright © Advanced Micro Devices, Inc., or its affiliates.
# SPDX-License-Identifier:  MIT

#!/bin/bash
# usage: resnet50_v1.5.sh <prec> <bs> [<cast1>] [<cast2>]
# where prec is the precision arg for the driver command
# bs is the batchsize for the network to use
# cast1 and cast2 are the cast types for the input tensors.
# For forward, they are input and weights tensors
# for backwards data, they are weights and output tensors
# for backwards weights, they are input and output tensors
export MIOPEN_DRIVER_USE_GPU_REFERENCE=1
# Enable/Disable if needed
export MIOPEN_FIND_MODE=1
# export MIOPEN_DISABLE_CACHE=1
export MIOPEN_LOG_LEVEL=7
# algorithm control
export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
export MIOPEN_DEBUG_CONV_DIRECT=0
export MIOPEN_DEBUG_CONV_WINOGRAD=0
# export MIOPEN_DEBUG_CONV_GEMM=0

cmd=$1
bs=$2
incast=$3
weicast=$4
verif=1

if [ ! -z $incast ] && [ ! -z $weicast ]
then
	fwdcast="--in_cast_type $incast --wei_cast_type $weicast"
	bwdcast="--wei_cast_type $incast --out_cast_type $weicast"
	wrwcast="--in_cast_type $incast --out_cast_type $weicast"
fi

echo resnet50_v1.5.sh CMD:${cmd} BS:${bs} CAST:${incast},${weicast}
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 512 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 2048 --out_channels 512 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 2048 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 2048 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 512 --out_channels 512 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 512 --out_channels 512 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 2048 --out_channels 512 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 2048 --out_channels 512 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 2048 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 2048 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 2048 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 512 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 1024 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 1024 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 256 --out_channels 256 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 256 --out_channels 256 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 256 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 256 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 1024 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 1024 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 128 --out_channels 512 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 7 --in_w 7 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 512 --out_channels 512 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 2048 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 512 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 1024 --out_channels 256 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 1024 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 14 --in_w 14 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 256 --out_channels 256 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 256 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 1024 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 128 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 256 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 128 --out_channels 128 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 128 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 512 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 64 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 64 --out_channels 64 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 64 --out_channels 256 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 64 --out_channels 64 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 230 --in_w 230 --fil_d 1 --fil_h 7 --fil_w 7 --in_channels 3 --out_channels 64 --forw 1 ${fwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 256 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 230 --in_w 230 --fil_d 1 --fil_h 7 --fil_w 7 --in_channels 3 --out_channels 64 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 64 --out_channels 64 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 64 --out_channels 64 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 64 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 64 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 64 --out_channels 64 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 64 --out_channels 64 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 64 --out_channels 256 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 64 --out_channels 256 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 128 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 512 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 128 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 128 --out_channels 512 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 128 --out_channels 512 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 128 --out_channels 128 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 1 --pad_w 1 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 3 --fil_w 3 --in_channels 128 --out_channels 128 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 128 --forw 2 ${bwdcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 1 --conv_stride_w 1 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 28 --in_w 28 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 512 --out_channels 128 --forw 4 ${wrwcast} -V ${verif} -t 1
./bin/MIOpenDriver ${cmd} --batchsize ${bs}  --spatial_dim 2 --pad_h 0 --pad_w 0 --pad_d 0 --conv_stride_h 2 --conv_stride_w 2 --conv_stride_d 1 --dilation_h 1 --dilation_w 1 --dilation_d 1 --group_count 1 --mode conv --pad_mode default --trans_output_pad_h 0 --trans_output_pad_w 0 --trans_output_pad_d 0  --in_d 1 --in_h 56 --in_w 56 --fil_d 1 --fil_h 1 --fil_w 1 --in_channels 256 --out_channels 512 --forw 2 ${bwdcast} -V ${verif} -t 1
