#
# Play from the command line
#

def do_play to_play

  $all_licks, $licks, $all_lick_progs = read_licks(use_opt_lick_prog: false)

  if !$extra
    # We expect lick-names on command line, so dont narrow to tag-selection
    $licks = $all_licks 
  elsif $opts[:lick_prog]
    err "Options --lick-prog only useful for extra argument licks, not #{$extra}" if $extra != 'licks'
    $licks = $all_licks 
    _ = process_opt_lick_prog
    $all_licks, $licks, $all_lick_progs = read_licks    
  end

  make_term_immediate

  puts "\n\e[2mType is #{$type}, key of #{$key}, scale #{$scale}, #{$licks.length} of #{$all_licks.length} licks.\e[0m"
  puts

  if $extra
    args_for_extra = to_play
  else
    holes_or_notes, semis, lnames, lpnames, snames, _, jmnames = partition_for_mode_or_amongs(to_play, extra_allowed: true)
  end

  # common error checking
  err_args_not_allowed(args_for_extra) if $extra == 'user' && args_for_extra.length > 0
  err_args_not_allowed(args_for_extra) if $extra == 'licks' && args_for_extra.length > 0
  err "Option '--start-with' only useful when playing 'licks'" if $opts[:start_with] && !$extra == 'licks'

  
  if !$extra 

    if holes_or_notes.length > 0

      puts "Playing holes or notes given as arguments."
      puts
      play_holes_or_notes_and_handle_kb holes_or_notes
      puts
      write_history('holes or notes', 'adhoc-holes', holes_or_notes)
      
    elsif snames.length > 0
      
      puts "Playing scales given as arguments."
      puts
      snames.each do |sname|
        scale_holes, _, _ = read_and_parse_scale_simple(sname)
        puts "Scale #{sname}"
        play_holes_or_notes_and_handle_kb scale_holes
        puts
        write_history('scale', sname, scale_holes)
      end
      
    elsif lnames.length > 0

      puts "Playing licks given as arguments."
      puts
      $opts[:iterate] = :cycle
      play_named_licks(lnames, refill: false)

    elsif semis.length > 0

      puts "Playing semitones given as arguments and converted to notes (a4 = 0st)."
      puts
      notes = semis.map {|s| semi2note(s.to_i)}
      play_holes_or_notes_and_handle_kb notes
      puts
      write_history('semitones converted to notes', 'adhoc-semitones', notes)
      
    elsif lpnames.length > 0

      err "Can only play only one lick progression, not: #{lpnames.join(',')}" if lpnames.length > 1

      puts "Playing lick progression given as argument."
      puts
      print_single_lick_prog($all_lick_progs[lpnames[0]])      
      lnames = $all_lick_progs[lpnames[0]][:licks]
      $opts[:iterate] = :cycle
      play_named_licks(lnames, refill: true)

    elsif jmnames.length > 0
      
      err "Can only play only one jam, not: #{lpnames.join(',')}" if jmnames.length > 1

      puts "Playing jam given as argument."
      puts
      do_the_jam_playing($jamming_rel2abs[jmnames[0]])
      
    else

      fail 'Internal error'

    end

  else

    case $extra
    when 'pitch'

      key = if args_for_extra.length == 1
              key_wo_digit = args_for_extra[0].gsub(/\d$/,'')
              err "Unknown key '#{key_wo_digit}'; none of #{$conf[:all_keys]}" unless $conf[:all_keys].include?(key_wo_digit)
              args_for_extra[0]
            elsif args_for_extra.length > 1
              err "harpwise play pitch only accepts zero or one argument, not #{args_for_extra}"
            else
              nil
            end
      play_interactive_pitch(start_key: key)

    when 'interval', 'inter'

      s1, s2 = normalize_interval(args_for_extra)

      play_interactive_interval s1, s2
        
    when 'licks'

      do_play_licks args_for_extra
      
    when 'progression', 'prog'
      
      err "Need a base hole or note and some semitone diffs or intervals to play a progression, e.g. 'a4 4st 10st'" unless args_for_extra.length >= 1
      progs = args_for_extra.
                # replace dot by something unlikely, because some day
                # it might also be part of a hole-notation
                map {|a| a == '.'  ?  '###'  :  a}.  
                join(' ').
                split('###').
                map {|p| p.split.map {|hns| hns.strip}}
      play_interactive_progression(
        progs.map {|p| base_and_delta_to_semis(p)},
        progs.map {|p| p.join(' ')} )

    when 'chord'

      puts "A chord"
      err "Need at least two holes or notes or semitone-diffs or intervals, e.g. 'c3 7st'" unless args_for_extra.length >= 1
      _, first = hole_or_note_or_semi(args_for_extra[0], false)
      semis = args_for_extra[1 .. -1].map do |arg|
        tp, sem = hole_or_note_or_semi(arg)
        if tp == :diff
          first + sem
        else
          sem
        end
      end
      semis.unshift(first)
      play_interactive_chord semis, args_for_extra

    when 'user'

      rfile = $ulrec.rec_file
      if File.exist?(rfile)
        duration = '%.1fs' % sox_query(rfile, 'Length')
        puts "Playing \e[32m#{rfile}\e[0m, #{duration} ..."
        puts "\e[2m(h for help)"
        play_recording_and_handle_kb rfile
        puts
      else
        puts "User lick recording #{rfile} not present;\nrecord yourself in mode lick to create it."
        puts
      end

    else

      fail "Internal error: unknown extra '#{extra}'"

    end

  end
  puts
  
end


def partition_for_mode_or_amongs to_handle, amongs: nil, extra_allowed: false

  holes_or_notes = []
  semis = []
  lnames = []
  lpnames = []
  snames = []
  spnames = []
  jmnames = []
  other = []

  amongs ||= $amongs[$mode] || err("Internal error: not for mode #{$mode}")
  err("Internal error: #{amongs} includes :extra_wwos") if amongs.include?(:extra_wwos)

  # allow -1 (oct) +2 to be passed as '-1 (oct) +2'
  to_handle.join(' ').split.each do |th|

    what = recognize_among(th, amongs)
    
    if what == :note
      holes_or_notes << sf_norm(th)
    elsif what == :hole
      holes_or_notes << th
    elsif what == :event
      holes_or_notes << th
    elsif what == :semi_note
      semis << th
    elsif what == :scale
      snames << th
    elsif what == :scale_prog
      spnames << th
    elsif what == :lick
      lnames << th
    elsif what == :lick_prog
      lpnames << th
    elsif what == :last
      $all_licks, $licks, $all_lick_progs = read_licks
      record = shortcut2history_record(th)
      lnames << record[:name]
    elsif what == :jam
      jmnames << th
    else
      other << th
    end
  end

  #
  # Check results for consistency
  # 

  types_count = [holes_or_notes, semis, lnames, snames, jmnames].select {|x| x.length > 0}.length

  if other.length > 0 
    puts
    puts "Cannot understand these arguments: #{other.join('  ')}#{not_any_source_of};"
    puts 'they are none of (exact match required):'
    print_amongs(amongs)
    if extra_allowed && $extra == ''
      puts
      puts "Alternatively you may give one of these extra keywords to #{$mode},\nwhich might be able to handle additional arguments:"
      print_amongs(:extra)
    end
    err "Cannot understand these arguments: #{other.join('  ')}\nSee above for full list of choices."
  end
  
  if extra_allowed && $extra == '' && types_count == 0
    puts
    puts "Nothing to handle for #{$mode}; please specify any of:"
    print_amongs([amongs, :extra])
    err 'See above'
  end
  
  if types_count > 1
    puts "The following #{types_count} types of arguments are present,\nbut ONLY ONE OF THEM can be handled at the same time:"
    puts
    puts "     Holes or Notes: #{holes_or_notes.join(' ')}" if holes_or_notes.length > 0
    puts "          semitones: #{semis.join(' ')}" if semis.length > 0
    puts "              Licks: #{lnames.join(' ')}" if lnames.length > 0
    puts "  Lick progressions: #{lpnames.join(' ')}" if lpnames.length > 0
    puts "             Scales: #{snames.join(' ')}" if snames.length > 0
    puts " Scale progressions: #{spnames.join(' ')}" if spnames.length > 0
    puts "               Jams: #{jmnames.join(' ')}" if jmnames.length > 0
    puts
    err 'See above'
  end

  return [holes_or_notes, semis, lnames, lpnames, snames, spnames, jmnames]

end


def hole_or_note_or_semi hns, diff_allowed = true

  # check if argument is interval or absolute note or hole or event or
  # many of them

  amongs = if diff_allowed
             [:hole, :note, :inter, :semi_note]
           else
             [:hole, :note]
           end
  what = recognize_among(hns, amongs)
  type, value = case what
                when :hole
                  [:abs, note2semi($hole2note[hns])]
                when :note
                  [:abs, note2semi(hns)]
                when :inter
                  [:diff, $intervals_inv[hns].to_i]
                when :semi_note
                  [:diff, hns.to_i]
                else
                  [nil, nil]
                end

  if !type
    print_amongs(*amongs)
    err "Given argument #{hns} is none of those given above"
  end
  
  return type, value
end


def normalize_interval args

  err "Need two arguments, to #{$mode} an interval (not #{args}):\n" +
      "  - a base-note or base-hole, e.g. 'c4' or '+2'\n" +
      "  - a difference in semitones, either as a number or as a name, e.g. '12st' or 'oct'\n" unless args.length == 2

  args.map!(&:downcase)
      
  tt = Array.new
  vv = Array.new
  args.each do |arg|
    t, v = hole_or_note_or_semi(arg)
    tt << t
    vv << v
  end
  s1 = s2 = 0
  case tt
  when [:abs, :abs]
    s1 = vv[0]
    s2 = vv[1]
  when [:diff, :diff]
    err "You specified two semitone-differences but no base note: #{args}"
  when [:abs, :diff]
    s1 = vv[0]
    s2 = s1 + vv[1]
  when [:diff, :abs]
    s1 = vv[1]
    s2 = s1 + vv[0]
  else
    fail "Internal error: unmatched: #{tt}"
  end

  return s1, s2
end


def base_and_delta_to_semis base_and_delta
  prog = Array.new
  bt, bv = hole_or_note_or_semi(base_and_delta[0], false)
  err "Progression should start with an absolute value (hole or note), but not with a semitone difference like #{base_and_delta[0]}" if bt == :diff
  prog << bv
  base_and_delta[1 .. -1].each do |diff|
    dt, dv = hole_or_note_or_semi(diff)
    err "Up from the second word of progression there are only semitone differences to initial note allowed (e.g. 9st or octave) but not an absolute note or hole like #{diff}; remark: in case of ambiguities between holes and semitones add 'st' to semitones, like in '3st'" if dt == :abs
    prog << prog[0] + dv
  end
  prog
end


def play_and_print_lick lick, extra = ''
  sleep 1 if $ctl_lk_hl[:loop_loop]
  $resources[:hl_wheel2].each do |col|
    print "\r\e[0m\e[34mLick   #{col}#{lick[:name]}"
    sleep 0.1
  end
  print "\e[0m\e[2m#{extra}, "
  if lick[:rec] && !$opts[:holes] && !$opts[:reverse]
    puts "rec in #{lick[:rec_key]}" +
         ( $key == lick[:rec_key]  ?  ''  :  ", shifted to #{$key}" ) +
         "    (h for help)\e[0m\e[2m"
    sleep 0.02
    puts "Tags:  #{lick[:tags].join(', ')}" if lick[:tags]
    sleep 0.02
    puts "Desc:  #{lick[:desc]}" unless lick[:desc].to_s.empty?
    print "\e[0m"
    puts lick[:holes].join(' ')
    play_lick_recording_and_handle_kb lick, lick[:rec_start], lick[:rec_length], 0, true
  else
    puts ( $opts[:reverse]  ?  ' in reverse'  :  '' ) +
         "    (h for help)\e[0m\e[2m"
    sleep 0.02
    puts "Tags:  #{lick[:tags].join(', ')}" if lick[:tags]
    sleep 0.02
    puts "Desc:  #{lick[:desc]}" unless lick[:desc].to_s.empty?
    print "\e[0m"
    play_lick_holes_and_handle_kb ( $opts[:reverse]  ?  lick[:holes].reverse  :  lick[:holes] ),
                                  lick: lick,
                                  scroll_allowed: true,
                                  with_head: false
  end
  sleep 0.02
  puts
end


def play_licks_controller licks, refill, sleep_between: false
  stock = licks.clone
  prev_licks = Array.new
  lick = stock.shift

  print "\e[2m"
  if refill
    print "Set of licks will be played without end, "
  else 
    print "Set of licks will be played once, "
  end
  if $opts[:iterate] == :random
    puts "shuffled and in random order."
  else
    puts "in given order."
  end
  puts "Please note, that different help and commands apply in play and in pauses."
  puts "\e[0m"
  
  
  loop do  ## one lick after the other

    write_history('lick', lick[:name], lick[:holes])
    
    loop do  ## repeats of the same lick
      play_and_print_lick lick, "    #{licks.length - stock.length}/#{licks.length}"
      
      if sleep_between && $ctl_lk_hl[:lick_lick]
        $ctl_kb_queue.clear
        plen = 5 
        print "\e[0m\e[2m#{plen} secs pause (TAB,+ to go on, h for help, RETURN for permanent pause) "
        (0..10*plen).each do |i|
          sleep 0.1
          print '.' if i % 10 == 5
          break if !$ctl_kb_queue.empty?
        end
        print "\e[0m"
      else
        sleep ( $opts[:fast] ? 0.25 : 0.5 )
      end
      if stock.length == 0 && !refill
        # last lick has been played, no need to ask
        lick = nil
        break
      end
      case maybe_wait_for_key_and_decide_replay($ctl_lk_hl[:lick_lick])
      when :next
        prev_licks << lick if lick && lick != prev_licks[-1]
        lick = stock.shift
        break
      when :redo
        redo
      when :edit
        puts
        edit_file($lick_file, lick[:lno])
        puts
        $all_licks, $licks, $all_lick_progs = read_licks
        redo
      when :named
        choose_prepare_for skip_term: true
        puts
        lnames = $all_licks.map {|l| l[:name]}
        input = choose_interactive("Please choose lick (current is #{lick[:name]}): ", lnames) do |lname|
          lk = $all_licks.find {|l| l[:name] == lname}
          "[#{lk[:tags].join(',')}] #{lk[:holes].length} holes, #{lk[:desc]}"
        end
        choose_clean_up skip_term: true
        if input
          lick = $all_licks.find {|l| l[:name] == input}
          puts "New lick."
        else
          puts "Canceled."
        end
      when :star_up
        star_unstar_lick(:up, lick)
        puts "Starred most recent lick"
        puts
      when :star_down
        star_unstar_lick(:down, lick)
        puts "Unstarred most recent lick"
        puts
      when :prev
        if prev_licks.length > 0
          lick = prev_licks.pop
        else
          puts "No previous lick available."
          puts
          redo
        end
        break
      end
    end  ## repeats of the same lick

    if !lick && stock.length == 0
      if refill
        print "\n\e[0mEvery lick played once, "
        if $opts[:iterate] == :random
          stock = refill.shuffle
          print "shuffled in random sequence."
        else
          stock = refill.clone
          print "in order of lickfile."
        end
        puts "   Starting over ..."
        puts
        lick = stock.shift
      else
        puts "Done with playing #{licks.length} licks."
        puts "\e[0m"
        return
      end
      print "\e[2m"      
    end
  end  ## one lick after the other
end


def maybe_wait_for_key_and_decide_replay puts_pending
  show_help = false
  if $ctl_lk_hl[:lick_lick] && $ctl_kb_queue.empty?
    $ctl_kb_queue.clear
    puts " \e[2mnext\e[0m" if puts_pending
    return :next
  else
    if $ctl_kb_queue.length > 0
      # different shortcuts apply before we even ask; these are similar to shortcuts during
      # previous play
      char = $ctl_kb_queue.deq
      if char == '+' || char == 'TAB'
        puts " \e[32mnext\e[0m" if puts_pending
        return :next
      end
      if char == 'h'
        show_help = true
        puts " \e[32mhelp\e[0m"
        puts
        puts_pending = false
      end
    end

    loop do
      # lines are devided in segments, which are highlighted if they change
      lines_long = [["\e[0mPress:      \e[92mh\e[32m: this help        \e[92m.r\e[32m: replay this lick    \e[92me\e[32m: edit lickfile"],
                    ["    \e[92mBACKSPACE\e[32m: previous lick    \e[92m*/\e[32m: star,unstar most recent lick"],
                    ["            \e[92mn\e[32m: choose lick by name"],
                    ["More keys (also while playing recordings but not holes):"],
                    ["      \e[92mc\e[32m: toggle continuous play, i.e. without a menu (now ",
                     ( $ctl_lk_hl[:lick_lick]  ?  " ON"  :  "OFF" ), ")"],
                    ["      \e[92mL\e[32m: toggle loop for all licks (now ",
                     ( $ctl_lk_hl[:loop_loop]  ?  " ON"  :  "OFF" ), ")"],
                    ["  \e[92m2-9,0\e[32m: set num loops fo all-licks looping (L) (now ",
                     "#{$ctl_lk_hl[:num_loops]}",")"],
                    ["\e[92mSPACE or RETURN\e[32m for next lick ..."]]
      lines = if show_help
                lines_long
              else
                [["\e[2mPress:      h: show help with more keys (available now already)"],
                 ["\e[2mSPACE or RETURN for next lick ..."]]
              end
      oldlines ||= lines
      oldlines_long ||= lines_long
      $ctl_kb_queue.clear
      if puts_pending
        puts " \e[32mpause\e[0m"
        puts
      end
      puts_pending = false

      # highlight diffs to initial state
      lines.zip(oldlines).each_with_index do |lns, idx|
        line, oldline = lns
        print "\e[0m"
        # not strings but rather arrays of segments
        line.zip(oldline).each do |seg, oldseg|
          if seg != oldseg
            print "\e[0m\e[34m"
            print seg.gsub(/\e.*?m/,'')
            # modify, so that highlight persists
            oldseg[0] = '#'
          else
            print seg
          end
          print "\e[0m"
        end
        puts unless idx == [lines.length, oldlines.length].max - 1
        sleep 0.02
      end
      print "\e[0m"
      char = $ctl_kb_queue.deq
      case char
      when 'BACKSPACE'
        $ctl_lk_hl[:lick_lick] = false
        puts " \e[32mprevious\e[0m"
        puts
        return :prev
      when 'n'
        puts " \e[32mnamed lick\e[0m"
        puts
        return :named
      when 'r','.'
        puts " \e[32mredo\e[0m"
        puts
        return :redo
      when 'e'
        puts " \e[32medit\e[0m"
        puts
        return :edit
      when 'h'
        puts " \e[32mhelp\e[0m"
        puts
        oldlines = nil
        show_help = true
        redo
      when 'c'
        puts
        $ctl_lk_hl[:lick_lick] = !$ctl_lk_hl[:lick_lick]
        show_help = true
        oldlines = oldlines_long        
        redo
      when 'L'
        puts
        $ctl_lk_hl[:loop_loop] = !$ctl_lk_hl[:loop_loop]
        show_help = true
        oldlines = oldlines_long        
        redo
      when '0'
        puts
        $ctl_lk_hl[:num_loops] = 0
        show_help = true
        oldlines = oldlines_long
        redo
      when '1'
        puts
        puts "\e[0m#{$resources[:nloops_not_one]}"
        puts
        redo
      when '2','3','4','5','6','7','8','9'
        puts
        $ctl_lk_hl[:num_loops] = char.to_i
        show_help = true
        oldlines = oldlines_long
        redo
      when ' ', 'RETURN'
        puts " \e[32mnext\e[0m"        
        puts
        return :next
      when '*'
        puts " \e[32mstar\e[0m"
        puts
        return :star_up
      when '/'
        puts " \e[32munstar\e[0m"
        puts
        return :star_down        
      else
        puts "\n\n\e[0mUnknown key: '#{char}' \e[2m(but more keys in play)"
        puts
        oldlines = nil
        show_help = true
        redo
      end
    end
  end
end


def do_play_licks args

  if $opts[:lick_radio]
    $ctl_lk_hl[:lick_lick] = $ctl_lk_hl[:loop_loop] = true
    $ctl_lk_hl[:num_loops] = 4
  end

  $ctl_lk_hl[:can_star_unstar] = true
  sw = $opts[:start_with]
  licks = if $opts[:iterate] == :random
            licks = $licks.shuffle
          else
            licks = $licks.clone
          end  
  idx = if sw 
          if record = shortcut2history_record(sw)
            # we canno use record[:lick_idx], because that is against unshuffled licks
            licks.each_with_index.find {|l,i| l[:name] == record[:name]}&.at(1) || 0
          else
            (0 ... licks.length).find {|i| licks[i][:name] == sw} or fail "Unknown lick #{sw} given for option '--start-with'" 
          end
        else
          0
        end
  licks.rotate!(idx)
  if $opts[:iterate] == :random
    puts "\e[2mA random walk through licks.\e[0m"
  else
    puts "\e[2mOne lick after the other.\e[0m"
  end  
  puts
  play_licks_controller licks, licks, sleep_between: true
end


def play_named_licks lnames, refill: true
  $ctl_lk_hl[:lick_lick] = false
  $ctl_lk_hl[:loop_loop] = false
  $ctl_lk_hl[:can_star_unstar] = true
  licks = lnames.map {|lnm| $licks.find {|l| l[:name] == lnm}}
  play_licks_controller licks, ( refill  ?  licks  :  nil )
end
