# ANUPQ, chapter 8
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("anupq05.tst");

# doc/examples.xml:29-122
gap> PqExample();
#I                   PqExample Index (Table of Contents)
#I                   -----------------------------------
#I  This table of possible examples is displayed when calling `PqExample'
#I  with no arguments, or with the argument: "index" (meant in the  sense
#I  of ``list''), or with a non-existent example name.
#I  
#I  Examples that have a name ending in `-ni' are  non-interactive  only.
#I  Examples that have a  name  ending  in  `-i'  are  interactive  only.
#I  Examples with names ending in `.g' also have  only  one  form.  Other
#I  examples have both a non-interactive and an  interactive  form;  call
#I  `PqExample' with 2nd argument `PqStart' to get the  interactive  form
#I  of the example. The substring `PG' in an  example  name  indicates  a
#I  p-Group Generation example, `SP' indicates  a  Standard  Presentation
#I  example, `Rel' indicates it uses  the  `Relators'  option,  and  `Id'
#I  indicates it uses the `Identities' option.
#I  
#I  The following ANUPQ examples are available:
#I  
#I   p-Quotient examples:
#I    general:
#I     "Pq"                   "Pq-ni"                "PqEpimorphism"        
#I     "PqPCover"             "PqSupplementInnerAutomorphisms"
#I    2-groups:
#I     "2gp-Rel"              "2gp-Rel-i"            "2gp-a-Rel-i"
#I     "B2-4"                 "B2-4-Id"              "B2-8-i"
#I     "B4-4-i"               "B4-4-a-i"             "B5-4.g"
#I    3-groups:
#I     "3gp-Rel-i"            "3gp-a-Rel"            "3gp-a-Rel-i"
#I     "3gp-a-x-Rel-i"        "3gp-maxoccur-Rel-i"
#I    5-groups:
#I     "5gp-Rel-i"            "5gp-a-Rel-i"          "5gp-b-Rel-i"
#I     "5gp-c-Rel-i"          "5gp-metabelian-Rel-i" "5gp-maxoccur-Rel-i"
#I     "F2-5-i"               "B2-5-i"               "R2-5-i"
#I     "R2-5-x-i"             "B5-5-Engel3-Id"
#I    7-groups:
#I     "7gp-Rel-i"
#I    11-groups:
#I     "11gp-i"               "11gp-Rel-i"           "11gp-a-Rel-i"
#I     "11gp-3-Engel-Id"      "11gp-3-Engel-Id-i"
#I  
#I   p-Group Generation examples:
#I    general:
#I     "PqDescendants-1"      "PqDescendants-2"      "PqDescendants-3"
#I     "PqDescendants-1-i"
#I    2-groups:
#I     "2gp-PG-i"             "2gp-PG-2-i"           "2gp-PG-3-i"
#I     "2gp-PG-4-i"           "2gp-PG-e4-i"
#I     "PqDescendantsTreeCoclassOne-16-i"
#I    3-groups:
#I     "3gp-PG-i"             "3gp-PG-4-i"           "3gp-PG-x-i"
#I     "3gp-PG-x-1-i"         "PqDescendants-treetraverse-i"
#I     "PqDescendantsTreeCoclassOne-9-i"
#I    5-groups:
#I     "5gp-PG-i"             "Nott-PG-Rel-i"        "Nott-APG-Rel-i"
#I     "PqDescendantsTreeCoclassOne-25-i"
#I    7,11-groups:
#I     "7gp-PG-i"             "11gp-PG-i"
#I  
#I   Standard Presentation examples:
#I    general:
#I     "StandardPresentation" "StandardPresentation-i"
#I     "EpimorphismStandardPresentation"
#I     "EpimorphismStandardPresentation-i"           "IsIsomorphicPGroup-ni"
#I    2-groups:
#I     "2gp-SP-Rel-i"         "2gp-SP-1-Rel-i"       "2gp-SP-2-Rel-i"
#I     "2gp-SP-3-Rel-i"       "2gp-SP-4-Rel-i"       "2gp-SP-d-Rel-i"
#I     "gp-256-SP-Rel-i"      "B2-4-SP-i"            "G2-SP-Rel-i"
#I    3-groups:
#I     "3gp-SP-Rel-i"         "3gp-SP-1-Rel-i"       "3gp-SP-2-Rel-i"
#I     "3gp-SP-3-Rel-i"       "3gp-SP-4-Rel-i"       "G3-SP-Rel-i"
#I    5-groups:
#I     "5gp-SP-Rel-i"         "5gp-SP-a-Rel-i"       "5gp-SP-b-Rel-i"
#I     "5gp-SP-big-Rel-i"     "5gp-SP-d-Rel-i"       "G5-SP-Rel-i"
#I     "G5-SP-a-Rel-i"        "Nott-SP-Rel-i"
#I    7-groups:
#I     "7gp-SP-Rel-i"         "7gp-SP-a-Rel-i"       "7gp-SP-b-Rel-i"
#I    11-groups:
#I     "11gp-SP-a-i"          "11gp-SP-a-Rel-i"      "11gp-SP-a-Rel-1-i"
#I     "11gp-SP-b-i"          "11gp-SP-b-Rel-i"      "11gp-SP-c-Rel-i"
#I  
#I  Notes
#I  -----
#I  1. The example (first) argument of  `PqExample'  is  a  string;  each
#I     example above is in double quotes to remind you to include them.
#I  2. Some examples accept options. To find  out  whether  a  particular
#I     example accepts options, display it first (by including  `Display'
#I     as  last  argument)  which  will  also  indicate  how  `PqExample'
#I     interprets the options, e.g. `PqExample("11gp-SP-a-i", Display);'.
#I  3. Try `SetInfoLevel(InfoANUPQ, <n>);' for  some  <n>  in  [2  ..  4]
#I     before calling PqExample, to see what's going on behind the scenes.
#I  

# doc/examples.xml:505-629
gap> G := ElementaryAbelianGroup( 9 );
<pc group of size 9 with 2 generators>
gap> procId := PqStart( G );;
gap> #
gap> #  Below, we use the option StepSize in order to construct descendants
gap> #  of coclass 1. This is equivalent to setting the StepSize to 1 in
gap> #  each descendant calculation.
gap> #
gap> #  The elementary abelian group of order 9 has 3 descendants of
gap> #  3-class 2 and 3-coclass 1, as the result of the next command
gap> #  shows. 
gap> #
gap> PqDescendants( procId : StepSize := 1 );
[ <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators> ]
gap> #
gap> #  Now we will compute the descendants of coclass 1 for each of the
gap> #  groups above. Then we will compute the descendants  of coclass 1
gap> #  of each descendant and so  on.  Note  that the  pq program keeps
gap> #  one file for each class at a time.  For example, the descendants
gap> #  calculation for  the  second  group  of class  2  overwrites the
gap> #  descendant file  obtained  from  the  first  group  of  class 2.
gap> #  Hence,  we have to traverse the descendants tree  in depth first
gap> #  order.
gap> #
gap> PqPGSetDescendantToPcp( procId, 2, 1 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
2
gap> PqPGSetDescendantToPcp( procId, 3, 1 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
2
gap> PqPGSetDescendantToPcp( procId, 4, 1 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
2
gap> #
gap> #  At this point we stop traversing the ``left most'' branch of the
gap> #  descendants tree and move upwards.
gap> #
gap> PqPGSetDescendantToPcp( procId, 4, 2 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> PqPGSetDescendantToPcp( procId, 3, 2 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> #  
gap> #  The computations above indicate that the descendants subtree under
gap> #  the first descendant of the elementary abelian group of order 9
gap> #  will have only one path of infinite length.
gap> #
gap> PqPGSetDescendantToPcp( procId, 2, 2 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
4
gap> #
gap> #  We get four descendants here, three of which will turn out to be
gap> #  incapable, i.e., they have no descendants and are terminal nodes
gap> #  in the descendants tree.
gap> #
gap> PqPGSetDescendantToPcp( procId, 2, 3 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> #
gap> #  The third descendant of class three is incapable.  Let us return
gap> #  to the second descendant of class 2.
gap> #
gap> PqPGSetDescendantToPcp( procId, 2, 2 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
4
gap> PqPGSetDescendantToPcp( procId, 3, 1 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> PqPGSetDescendantToPcp( procId, 3, 2 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> #
gap> #  We skip the third descendant for the moment ... 
gap> #
gap> PqPGSetDescendantToPcp( procId, 3, 4 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> #
gap> #  ... and look at it now.
gap> #
gap> PqPGSetDescendantToPcp( procId, 3, 3 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
6
gap> #
gap> #  In this branch of the descendant tree we get 6 descendants of class
gap> #  three.  Of those 5 will turn out to be incapable and one will have
gap> #  7 descendants.
gap> #
gap> PqPGSetDescendantToPcp( procId, 4, 1 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0
gap> PqPGSetDescendantToPcp( procId, 4, 2 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
7
gap> PqPGSetDescendantToPcp( procId, 4, 3 );
gap> PqPGExtendAutomorphisms( procId );
gap> PqPGConstructDescendants( procId : StepSize := 1 );
#I  group restored from file is incapable
0

#
gap> STOP_TEST("anupq05.tst", 1);
