/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jkate.Comment;
import com.fluendo.jkate.Info;
import com.fluendo.jkate.State;
import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import java.util.Vector;

public class KateDec
extends Element
implements OggPayload {
    private static final byte[] signature;
    private Info ki;
    private Comment kc;
    private State k;
    private Packet op;
    private int packetno;
    private long basetime = 0L;
    private long lastTs;
    private boolean haveDecoder = false;
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            return KateDec.this.sinkPad.pushEvent(event);
        }
    };
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            boolean bl;
            switch (event.getType()) {
                case 1: {
                    bl = KateDec.this.srcPad.pushEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, "synced " + this);
                        break;
                    }
                }
                case 2: {
                    bl = KateDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 3: {
                    Debug.log(3, "got EOS " + this);
                    bl = KateDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 4: {
                    KateDec.this.basetime = event.parseNewsegmentStart();
                    Debug.info("new segment: base time " + KateDec.this.basetime);
                    bl = KateDec.this.srcPad.pushEvent(event);
                    break;
                }
                default: {
                    bl = KateDec.this.srcPad.pushEvent(event);
                }
            }
            return bl;
        }

        protected int chainFunc(Buffer buffer) {
            int n;
            block10: {
                Debug.log(4, String.valueOf(this.parent.getName()) + " <<< " + buffer);
                ((KateDec)KateDec.this).op.packet_base = buffer.data;
                ((KateDec)KateDec.this).op.packet = buffer.offset;
                ((KateDec)KateDec.this).op.bytes = buffer.length;
                ((KateDec)KateDec.this).op.b_o_s = KateDec.this.packetno == 0 ? 1 : 0;
                ((KateDec)KateDec.this).op.e_o_s = 0;
                ((KateDec)KateDec.this).op.packetno = KateDec.this.packetno;
                long l = buffer.timestamp;
                Debug.log(4, "Kate chainFunc with packetno " + KateDec.this.packetno + ", haveDecoder " + KateDec.this.haveDecoder);
                if (!KateDec.this.haveDecoder) {
                    int n2 = KateDec.this.takeHeader(KateDec.this.op);
                    if (n2 < 0) {
                        buffer.free();
                        Debug.log(1, "does not contain Kate data.");
                        return -5;
                    }
                    if (n2 > 0) {
                        Debug.log(4, "Kate initialized for decoding");
                        this.caps = new Caps("application/x-kate-event");
                    }
                    buffer.free();
                    KateDec kateDec = KateDec.this;
                    kateDec.packetno = kateDec.packetno + 1;
                    return 0;
                }
                if ((((KateDec)KateDec.this).op.packet_base[((KateDec)KateDec.this).op.packet] & 0x80) == 128) {
                    Debug.log(4, "ignoring header");
                    buffer.free();
                    return 0;
                }
                if (l != -1L) {
                    KateDec.this.lastTs = l;
                }
                n = KateDec.this.k.decodePacketin(KateDec.this.op);
                if (n >= 0) break block10;
                buffer.free();
                Debug.log(1, "Error Decoding Kate.");
                KateDec.this.postMessage(Message.newError(this, "Error decoding Kate"));
                return -5;
            }
            try {
                com.fluendo.jkate.Event event = KateDec.this.k.decodeEventOut();
                if (event != null) {
                    buffer.object = event;
                    buffer.caps = this.caps;
                    buffer.timestamp = KateDec.this.granuleToDuration(event.start);
                    buffer.timestampEnd = buffer.timestamp + KateDec.this.granuleToDuration(event.duration);
                    Debug.log(4, String.valueOf(this.parent.getName()) + " >>> " + buffer);
                    Debug.debug("Got Kate text: " + new String(event.text) + " from " + buffer.timestamp + " to " + buffer.timestampEnd + ", basetime " + KateDec.this.basetime);
                    n = KateDec.this.srcPad.push(buffer);
                    Debug.log(4, "push returned " + n);
                } else {
                    Debug.debug("Got no event");
                    buffer.free();
                    n = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                KateDec.this.postMessage(Message.newError(this, exception.getMessage()));
                n = -5;
            }
            KateDec kateDec = KateDec.this;
            kateDec.packetno = kateDec.packetno + 1;
            return n;
        }

        protected boolean activateFunc(int n) {
            return true;
        }
    };

    static {
        byte[] byArray = new byte[8];
        byArray[0] = -128;
        byArray[1] = 107;
        byArray[2] = 97;
        byArray[3] = 116;
        byArray[4] = 101;
        signature = byArray;
    }

    public boolean isType(Packet packet) {
        return this.typeFind(packet.packet_base, packet.packet, packet.bytes) > 0;
    }

    public boolean isKeyFrame(Packet packet) {
        return true;
    }

    public boolean isDiscontinuous() {
        return true;
    }

    public int takeHeader(Packet packet) {
        int n = this.ki.decodeHeader(this.kc, packet);
        if (n > 0) {
            this.k.decodeInit(this.ki);
            Debug.debug("Kate decoder ready");
            this.haveDecoder = true;
        }
        return n;
    }

    public boolean isHeader(Packet packet) {
        return (packet.packet_base[packet.packet] & 0x80) == 128;
    }

    public long getFirstTs(Vector vector) {
        int n = vector.size();
        Buffer buffer = null;
        int n2 = 0;
        while (n2 < n) {
            buffer = (Buffer)vector.elementAt(n2);
            if (buffer.time_offset != -1L) break;
            ++n2;
        }
        if (n2 == vector.size()) {
            return -1L;
        }
        long l = this.granuleToTime(buffer.time_offset);
        buffer = (Buffer)vector.elementAt(0);
        buffer.timestamp = l - (long)(n2 + 1) * (1000000L * (long)this.ki.gps_denominator / (long)this.ki.gps_numerator);
        return l;
    }

    public long granuleToTime(long l) {
        if (l < 0L || !this.haveDecoder) {
            return -1L;
        }
        long l2 = (long)(this.k.granuleTime(l) * 1000000.0);
        return l2;
    }

    public long granuleToDuration(long l) {
        if (l < 0L || !this.haveDecoder) {
            return -1L;
        }
        long l2 = (long)(this.k.granuleDuration(l) * 1000000.0);
        return l2;
    }

    public KateDec() {
        this.ki = new Info();
        this.kc = new Comment();
        this.k = new State();
        this.op = new Packet();
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }

    protected int changeState(int n) {
        switch (n) {
            case 18: {
                this.lastTs = -1L;
                this.packetno = 0;
                break;
            }
        }
        int n2 = super.changeState(n);
        switch (n) {
            case 33: {
                this.ki.clear();
                this.kc.clear();
                this.k.clear();
                break;
            }
        }
        return n2;
    }

    public Object getProperty(String string) {
        if (string.equals("language")) {
            return this.ki.language;
        }
        if (string.equals("category")) {
            return this.ki.category;
        }
        return super.getProperty(string);
    }

    public String getFactoryName() {
        return "katedec";
    }

    public String getMime() {
        return "application/x-kate";
    }

    public int typeFind(byte[] byArray, int n, int n2) {
        if (MemUtils.startsWith(byArray, n, n2, signature)) {
            return 10;
        }
        return -1;
    }
}

